/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FST;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.FSTStore;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.fst.ReverseRandomAccessReader;

public final class OffHeapFSTStore
implements FSTStore {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OffHeapFSTStore.class);
    private IndexInput in;
    private long offset;
    private long numBytes;

    @Override
    public void init(DataInput in, long numBytes) throws IOException {
        if (!(in instanceof IndexInput)) {
            throw new IllegalArgumentException("parameter:in should be an instance of IndexInput for using OffHeapFSTStore, not a " + in.getClass().getName());
        }
        this.in = (IndexInput)in;
        this.numBytes = numBytes;
        this.offset = this.in.getFilePointer();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public long size() {
        return this.numBytes;
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        try {
            return new ReverseRandomAccessReader(this.in.randomAccessSlice(this.offset, this.numBytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("writeToOutput operation is not supported for OffHeapFSTStore");
    }
}

