/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

class OtelHelper {
    private static final Logger logger = LogManager.getLogger(OtelHelper.class);

    OtelHelper() {
    }

    static Attributes fromMap(Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return Attributes.empty();
        }
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((k, v) -> {
            if (v instanceof String) {
                String value = (String)v;
                builder.put(k, value);
            } else if (v instanceof Long) {
                Long value = (Long)v;
                builder.put(k, value.longValue());
            } else if (v instanceof Integer) {
                Integer value = (Integer)v;
                builder.put(k, (long)value.intValue());
            } else if (v instanceof Byte) {
                Byte value = (Byte)v;
                builder.put(k, (long)value.byteValue());
            } else if (v instanceof Short) {
                Short value = (Short)v;
                builder.put(k, (long)value.shortValue());
            } else if (v instanceof Double) {
                Double value = (Double)v;
                builder.put(k, value.doubleValue());
            } else if (v instanceof Float) {
                Float value = (Float)v;
                builder.put(k, (double)value.floatValue());
            } else if (v instanceof Boolean) {
                Boolean value = (Boolean)v;
                builder.put(k, value.booleanValue());
            } else {
                throw new IllegalArgumentException("attributes do not support value type of [" + v.getClass().getCanonicalName() + "]");
            }
        });
        return builder.build();
    }

    static Consumer<ObservableDoubleMeasurement> doubleMeasurementCallback(Supplier<Collection<DoubleWithAttributes>> observer) {
        return measurement -> {
            Collection observations;
            try {
                observations = (Collection)observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                logger.error("doubleMeasurementCallback observer unexpected error", (Throwable)err);
                return;
            }
            if (observations == null) {
                return;
            }
            for (DoubleWithAttributes observation : observations) {
                if (observation == null) continue;
                measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
            }
        };
    }

    static Consumer<ObservableLongMeasurement> longMeasurementCallback(Supplier<Collection<LongWithAttributes>> observer) {
        return measurement -> {
            Collection observations;
            try {
                observations = (Collection)observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                logger.error("longMeasurementCallback observer unexpected error", (Throwable)err);
                return;
            }
            if (observations == null) {
                return;
            }
            for (LongWithAttributes observation : observations) {
                if (observation == null) continue;
                measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
            }
        };
    }
}

