/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.unboundidds.tools.ParallelUpdate;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.WakeableSleeper;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ParallelUpdateProgressMonitor
extends Thread {
    private volatile boolean stopRequested;
    @NotNull
    private final ParallelUpdate parallelUpdate;
    @NotNull
    private final WakeableSleeper sleeper;

    ParallelUpdateProgressMonitor(@NotNull ParallelUpdate parallelUpdate) {
        super("Parallel Update Progress Monitor");
        this.parallelUpdate = parallelUpdate;
        this.stopRequested = false;
        this.sleeper = new WakeableSleeper();
    }

    @Override
    public void run() {
        while (!this.stopRequested) {
            this.sleeper.sleep(5000L);
            this.parallelUpdate.printIntervalData();
        }
    }

    void stopRunning() {
        this.stopRequested = true;
        this.sleeper.shutDown();
    }
}

