/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.TreeMap;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.hash.MurmurHash3;

public final class IDGenerator {
    private static final byte[] NULL_VALUE = "__NULL_VALUE__".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EMPTY_VALUE = "__EMPTY_VALUE__".getBytes(StandardCharsets.UTF_8);
    private static final byte DELIM = 36;
    private static final long SEED = 19L;
    private static final int MAX_FIRST_BYTES = 5;
    private final TreeMap<String, Object> objectsForIDGeneration = new TreeMap();

    public void add(String key, Object value) {
        if (this.objectsForIDGeneration.containsKey(key)) {
            throw new IllegalArgumentException("Keys must be unique");
        }
        this.objectsForIDGeneration.put(key, value);
    }

    public String getID() {
        if (this.objectsForIDGeneration.size() == 0) {
            throw new RuntimeException("Add at least 1 object before generating the ID");
        }
        BytesRefBuilder buffer = new BytesRefBuilder();
        BytesRefBuilder hashedBytes = new BytesRefBuilder();
        for (Object value : this.objectsForIDGeneration.values()) {
            byte[] v = IDGenerator.getBytes(value);
            if (v.length == 0) {
                v = EMPTY_VALUE;
            }
            buffer.append(v, 0, v.length);
            buffer.append((byte)36);
            if (hashedBytes.length() > 5) continue;
            hashedBytes.append(v[0]);
        }
        MurmurHash3.Hash128 hasher = MurmurHash3.hash128((byte[])buffer.bytes(), (int)0, (int)buffer.length(), (long)19L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        hashedBytes.append(Numbers.longToBytes((long)hasher.h1), 0, 8);
        hashedBytes.append(Numbers.longToBytes((long)hasher.h2), 0, 8);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(hashedBytes.bytes());
    }

    private static byte[] getBytes(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Long) {
            return Numbers.longToBytes((long)((Long)value));
        }
        if (value instanceof Double) {
            return Numbers.doubleToBytes((double)((Double)value));
        }
        if (value instanceof Integer) {
            return Numbers.intToBytes((int)((Integer)value));
        }
        if (value instanceof Boolean) {
            return new byte[]{(Boolean)value != false ? (byte)1 : 0};
        }
        throw new IllegalArgumentException("Value of type [" + String.valueOf(value.getClass()) + "] is not supported");
    }
}

