/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Releasable;

public class EnrichPolicyLocks {
    private final ConcurrentHashMap<String, Semaphore> policyLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> workingIndices = new ConcurrentHashMap();

    public EnrichPolicyLock lockPolicy(String policyName) {
        return this.lockPolicy(policyName, null);
    }

    public EnrichPolicyLock lockPolicy(String policyName, String enrichIndexName) {
        Semaphore runLock = this.policyLocks.computeIfAbsent(policyName, name -> new Semaphore(1));
        boolean acquired = runLock.tryAcquire();
        if (!acquired) {
            throw new EsRejectedExecutionException("Could not obtain lock because policy execution for [" + policyName + "] is already in progress.");
        }
        if (enrichIndexName != null) {
            Semaphore previous = this.workingIndices.putIfAbsent(enrichIndexName, runLock);
            assert (previous == null) : "Target index [" + enrichIndexName + "] is already claimed by an execution, or was not cleaned up.";
        }
        return new EnrichPolicyLock(policyName, enrichIndexName, runLock);
    }

    public Set<String> lockedPolices() {
        return Collections.unmodifiableSet(this.policyLocks.keySet());
    }

    public Set<String> inflightPolicyIndices() {
        return Collections.unmodifiableSet(this.workingIndices.keySet());
    }

    public class EnrichPolicyLock
    implements Releasable {
        private final String policyName;
        private final String enrichIndexName;
        private final Semaphore executionLease;

        private EnrichPolicyLock(String policyName, String enrichIndexName, Semaphore executionLease) {
            this.policyName = policyName;
            this.enrichIndexName = enrichIndexName;
            this.executionLease = executionLease;
        }

        public void close() {
            boolean wasRemoved;
            if (this.enrichIndexName != null) {
                wasRemoved = EnrichPolicyLocks.this.workingIndices.remove(this.enrichIndexName, this.executionLease);
                assert (wasRemoved) : "Target index [" + this.enrichIndexName + "] for policy [" + this.policyName + "] was removed prior to policy unlock";
            }
            wasRemoved = EnrichPolicyLocks.this.policyLocks.remove(this.policyName, this.executionLease);
            assert (wasRemoved) : "Second attempt was made to unlock policy [" + this.policyName + "]";
        }
    }
}

