/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.LatLonShapeDVAtomicShapeFieldData;

public class LatLonShapeIndexFieldData
extends AbstractShapeIndexFieldData<GeoShapeValues> {
    public LatLonShapeIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, toScriptFieldFactory);
    }

    public LeafShapeFieldData<GeoShapeValues> load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
        if (info != null) {
            LatLonShapeIndexFieldData.checkCompatible(info, "geo_shape");
        }
        return new LatLonShapeDVAtomicShapeFieldData(reader, this.fieldName, (ToScriptFieldFactory<GeoShapeValues>)this.toScriptFieldFactory);
    }

    @Override
    protected IllegalArgumentException sortException() {
        return new IllegalArgumentException("can't sort on geo_shape field without using specific sorting feature, like geo_distance");
    }
}

