/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata.plain;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.GeometryFieldScript;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeScriptDocValues;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.LeafShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public final class GeoShapeScriptFieldData
extends AbstractShapeIndexFieldData<GeoShapeValues> {
    private final GeometryFieldScript.LeafFactory leafFactory;

    private GeoShapeScriptFieldData(String fieldName, GeometryFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory) {
        super(fieldName, GeoShapeValuesSourceType.instance(), toScriptFieldFactory);
        this.leafFactory = leafFactory;
    }

    @Override
    protected IllegalArgumentException sortException() {
        throw new IllegalArgumentException("can't sort on geo_shape field");
    }

    public LeafShapeFieldData<GeoShapeValues> load(LeafReaderContext context) {
        final GeometryFieldScript script = this.leafFactory.newInstance(context);
        return new LeafShapeFieldData<GeoShapeValues>(this.toScriptFieldFactory){

            @Override
            public GeoShapeValues getShapeValues() {
                return new GeoShapeScriptDocValues(script, GeoShapeScriptFieldData.this.fieldName);
            }

            public long ramBytesUsed() {
                return 0L;
            }
        };
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final GeometryFieldScript.LeafFactory leafFactory;
        private final ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory;

        public Builder(String name, GeometryFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<GeoShapeValues> toScriptFieldFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public GeoShapeScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new GeoShapeScriptFieldData(this.name, this.leafFactory, this.toScriptFieldFactory);
        }
    }
}

