/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CancelReindexDataStreamAction
extends ActionType<AcknowledgedResponse> {
    public static final CancelReindexDataStreamAction INSTANCE = new CancelReindexDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/reindex_cancel";

    public CancelReindexDataStreamAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest {
        private final String index;

        public Request(String index) {
            this.index = index;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean getShouldStoreResult() {
            return true;
        }

        public String getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Objects.hashCode(this.index);
        }

        public boolean equals(Object other) {
            return other instanceof Request && this.index.equals(((Request)((Object)other)).index);
        }

        public Request nodeRequest(String thisNodeId, long thisTaskId) {
            Request copy = new Request(this.index);
            copy.setParentTask(thisNodeId, thisTaskId);
            return copy;
        }

        public String[] indices() {
            return new String[]{this.index};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }
    }
}

