/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.system_indices.task.SystemIndexMigrationTaskParams;
import org.elasticsearch.system_indices.task.SystemIndexMigrationTaskState;
import org.elasticsearch.system_indices.task.SystemIndexMigrator;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;

public class SystemIndexMigrationExecutor
extends PersistentTasksExecutor<SystemIndexMigrationTaskParams> {
    private final Client client;
    private final ClusterService clusterService;
    private final SystemIndices systemIndices;
    private final IndexScopedSettings indexScopedSettings;
    private final ThreadPool threadPool;

    public SystemIndexMigrationExecutor(Client client, ClusterService clusterService, SystemIndices systemIndices, IndexScopedSettings indexScopedSettings, ThreadPool threadPool) {
        super("upgrade-system-indices", (Executor)clusterService.threadPool().generic());
        this.client = client;
        this.clusterService = clusterService;
        this.systemIndices = systemIndices;
        this.indexScopedSettings = indexScopedSettings;
        this.threadPool = threadPool;
    }

    protected void nodeOperation(AllocatedPersistentTask task, SystemIndexMigrationTaskParams params, PersistentTaskState state) {
        SystemIndexMigrator upgrader = (SystemIndexMigrator)task;
        SystemIndexMigrationTaskState upgraderState = (SystemIndexMigrationTaskState)state;
        upgrader.run(upgraderState);
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<SystemIndexMigrationTaskParams> taskInProgress, Map<String, String> headers) {
        return new SystemIndexMigrator(this.client, id, type, action, parentTaskId, headers, this.clusterService, this.systemIndices, this.indexScopedSettings, this.threadPool);
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(SystemIndexMigrationTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        DiscoveryNode discoveryNode = clusterState.nodes().getMasterNode();
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("upgrade-system-indices", new String[0]), SystemIndexMigrationTaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("upgrade-system-indices", new String[0]), SystemIndexMigrationTaskState::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "upgrade-system-indices", SystemIndexMigrationTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "upgrade-system-indices", SystemIndexMigrationTaskParams::new));
    }
}

