/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class ModelEntity<ME extends ModelEntity<ME>>
implements Optimisation.Constraint,
Optimisation.Objective,
Comparable<ME> {
    private static final BigDecimal LARGEST = new BigDecimal(Double.toString(Double.MAX_VALUE), new MathContext(8, RoundingMode.DOWN));
    private static final BigDecimal SMALLEST = new BigDecimal(Double.toString(Double.MIN_NORMAL), new MathContext(8, RoundingMode.UP));
    static final NumberContext DISPLAY = NumberContext.ofScale(6);
    private transient int myAdjustmentExponent = Integer.MIN_VALUE;
    private BigDecimal myContributionWeight = null;
    private BigDecimal myLowerLimit = null;
    private final String myName;
    private BigDecimal myUpperLimit = null;

    static int deriveAdjustmentExponent(AggregatorFunction<BigDecimal> largest, AggregatorFunction<BigDecimal> smallest, int range) {
        int doubleRange;
        double expL = MissingMath.log10(largest.doubleValue(), PrimitiveMath.ZERO);
        if (expL > (double)(doubleRange = 2 * range)) {
            return 0;
        }
        double expS = Math.max(MissingMath.log10(smallest.doubleValue(), -doubleRange), expL - (double)range);
        double negatedAverage = (expL + expS) / -PrimitiveMath.TWO;
        return MissingMath.roundToInt(negatedAverage);
    }

    static BigDecimal toBigDecimal(Comparable<?> number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        BigDecimal candidate = TypeUtils.toBigDecimal(number);
        BigDecimal magnitude = candidate.abs();
        if (magnitude.compareTo(LARGEST) >= 0) {
            candidate = null;
        } else if (magnitude.compareTo(SMALLEST) <= 0) {
            candidate = BigMath.ZERO;
        }
        return candidate;
    }

    private ModelEntity() {
        this("");
    }

    protected ModelEntity(ME entityToCopy) {
        this.myName = ((ModelEntity)entityToCopy).getName();
        this.myContributionWeight = ((ModelEntity)entityToCopy).getContributionWeight();
        this.myLowerLimit = ((ModelEntity)entityToCopy).getLowerLimit();
        this.myUpperLimit = ((ModelEntity)entityToCopy).getUpperLimit();
        this.myAdjustmentExponent = ((ModelEntity)entityToCopy).getAdjustmentExponentValue();
    }

    protected ModelEntity(String name) {
        this.myName = name;
        ProgrammingError.throwIfNull((Object)name);
    }

    public abstract void addTo(Expression var1, BigDecimal var2);

    public final BigDecimal adjust(BigDecimal factor) {
        return factor.movePointRight(this.getAdjustmentExponent());
    }

    public final boolean equals(Object obj) {
        boolean retVal = false;
        if (obj instanceof ModelEntity && this.myName.equals(((ModelEntity)obj).getName())) {
            retVal = true;
        }
        return retVal;
    }

    public final double getAdjustedLowerLimit() {
        return this.toLowerValue(true);
    }

    public final double getAdjustedUpperLimit() {
        return this.toUpperValue(true);
    }

    public final double getAdjustmentFactor() {
        return BigDecimal.ONE.movePointRight(this.getAdjustmentExponent()).doubleValue();
    }

    @Override
    public final BigDecimal getContributionWeight() {
        return this.myContributionWeight;
    }

    @Override
    public final BigDecimal getLowerLimit() {
        return this.myLowerLimit;
    }

    public final String getName() {
        return this.myName;
    }

    public final double getUnadjustedLowerLimit() {
        return this.toLowerValue(false);
    }

    public final double getUnadjustedUpperLimit() {
        return this.toUpperValue(false);
    }

    @Override
    public final BigDecimal getUpperLimit() {
        return this.myUpperLimit;
    }

    public final int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    public final boolean isConstraint() {
        return this.myLowerLimit != null || this.myUpperLimit != null;
    }

    public final boolean isContributionWeightSet() {
        return this.myContributionWeight != null;
    }

    @Override
    public final boolean isEqualityConstraint() {
        return this.myLowerLimit != null && this.myUpperLimit != null && this.myLowerLimit.compareTo(this.myUpperLimit) == 0;
    }

    public abstract boolean isInteger();

    @Override
    public final boolean isLowerConstraint() {
        return this.myLowerLimit != null && !this.isEqualityConstraint();
    }

    public final boolean isLowerLimitSet() {
        return this.myLowerLimit != null;
    }

    @Override
    public final boolean isObjective() {
        return this.myContributionWeight != null && this.myContributionWeight.signum() != 0;
    }

    @Override
    public final boolean isUpperConstraint() {
        return this.myUpperLimit != null && !this.isEqualityConstraint();
    }

    public final boolean isUpperLimitSet() {
        return this.myUpperLimit != null;
    }

    public final ME level(Comparable<?> level) {
        BigDecimal value = ModelEntity.toBigDecimal(level);
        return ((ModelEntity)this.lower(value)).upper(value);
    }

    public final ME level(double level) {
        return this.level(BigDecimal.valueOf(level));
    }

    public final ME level(long level) {
        return this.level(BigDecimal.valueOf(level));
    }

    public ME lower(Comparable<?> lower) {
        this.myLowerLimit = ModelEntity.toBigDecimal(lower);
        return (ME)this;
    }

    public final ME lower(double lower) {
        return this.lower(BigDecimal.valueOf(lower));
    }

    public final ME lower(long lower) {
        return this.lower(BigDecimal.valueOf(lower));
    }

    public final BigDecimal reverseAdjustment(BigDecimal adjusted) {
        if (this.myAdjustmentExponent != 0) {
            return adjusted.movePointLeft(this.myAdjustmentExponent);
        }
        return adjusted;
    }

    public void shift(BigDecimal shift) {
        if (this.isLowerLimitSet()) {
            this.lower(this.getLowerLimit().add(shift));
        }
        if (this.isUpperLimitSet()) {
            this.upper(this.getUpperLimit().add(shift));
        }
    }

    public final double toAdjusted(BigDecimal unadjusted) {
        if (unadjusted == null) {
            return Double.NaN;
        }
        if (unadjusted.signum() == 0) {
            return PrimitiveMath.ZERO;
        }
        if (this.myAdjustmentExponent == 0) {
            return unadjusted.doubleValue();
        }
        return unadjusted.movePointRight(this.myAdjustmentExponent).doubleValue();
    }

    public final String toString() {
        StringBuilder retVal = new StringBuilder();
        this.appendToString(retVal);
        return retVal.toString();
    }

    public final BigDecimal toUnadjusted(double adjusted, NumberContext context) {
        BigDecimal retVal = new BigDecimal(adjusted, context.getMathContext());
        retVal = this.reverseAdjustment(retVal);
        retVal = context.enforce(retVal);
        if (this.myLowerLimit != null) {
            retVal = retVal.max(this.myLowerLimit);
        }
        if (this.myUpperLimit != null) {
            retVal = retVal.min(this.myUpperLimit);
        }
        return retVal;
    }

    public ME upper(Comparable<?> upper) {
        this.myUpperLimit = ModelEntity.toBigDecimal(upper);
        return (ME)this;
    }

    public final ME upper(double upper) {
        return this.upper(BigDecimal.valueOf(upper));
    }

    public final ME upper(long upper) {
        return this.upper(BigDecimal.valueOf(upper));
    }

    public final ME weight(Comparable<?> weight) {
        this.myContributionWeight = ModelEntity.toBigDecimal(weight);
        if (this.myContributionWeight != null && this.myContributionWeight.signum() == 0) {
            this.myContributionWeight = null;
        }
        return (ME)this;
    }

    public final ME weight(double weight) {
        return this.weight(BigDecimal.valueOf(weight));
    }

    public final ME weight(long weight) {
        return this.weight(BigDecimal.valueOf(weight));
    }

    private double toLowerValue(boolean adjusted) {
        int adjustmentExponent;
        BigDecimal limit = adjusted && this.myLowerLimit != null ? ((adjustmentExponent = this.getAdjustmentExponent()) != 0 ? this.myLowerLimit.movePointRight(adjustmentExponent) : this.myLowerLimit) : this.myLowerLimit;
        if (limit != null) {
            return limit.doubleValue();
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double toUpperValue(boolean adjusted) {
        int adjustmentExponent;
        BigDecimal limit = adjusted && this.myUpperLimit != null ? ((adjustmentExponent = this.getAdjustmentExponent()) != 0 ? this.myUpperLimit.movePointRight(adjustmentExponent) : this.myUpperLimit) : this.myUpperLimit;
        if (limit != null) {
            return limit.doubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    protected void appendLeftPart(StringBuilder builder) {
        if (this.isLowerConstraint() || this.isEqualityConstraint()) {
            builder.append(DISPLAY.enforce(this.getLowerLimit()).toPlainString());
            builder.append(" <= ");
        }
    }

    protected void appendMiddlePart(StringBuilder builder) {
        builder.append(this.getName());
        if (this.isObjective()) {
            builder.append(" (");
            builder.append(DISPLAY.enforce(this.getContributionWeight()).toPlainString());
            builder.append(")");
        }
    }

    protected void appendRightPart(StringBuilder builder) {
        if (this.isUpperConstraint() || this.isEqualityConstraint()) {
            builder.append(" <= ");
            builder.append(DISPLAY.enforce(this.getUpperLimit()).toPlainString());
        }
    }

    protected void destroy() {
        this.myContributionWeight = null;
        this.myLowerLimit = null;
        this.myUpperLimit = null;
    }

    protected final int getAdjustmentExponent() {
        if (this.myAdjustmentExponent == Integer.MIN_VALUE) {
            this.myAdjustmentExponent = this.deriveAdjustmentExponent();
        }
        return this.myAdjustmentExponent;
    }

    protected final boolean validate(BasicLogger.Printer appender) {
        boolean retVal = true;
        if (this.myLowerLimit != null && this.myUpperLimit != null && (this.myLowerLimit.compareTo(this.myUpperLimit) == 1 || this.myUpperLimit.compareTo(this.myLowerLimit) == -1)) {
            if (appender != null) {
                appender.println(this.toString() + " The lower limit (if it exists) must be smaller than or equal to the upper limit (if it exists)!");
            }
            retVal = false;
        }
        if (this.myContributionWeight != null && this.myContributionWeight.signum() == 0) {
            if (appender != null) {
                appender.println(this.toString() + " The contribution weight (if it exists) should not be zero!");
            }
            retVal = false;
        }
        return retVal;
    }

    protected boolean validate(BigDecimal value, NumberContext context, BasicLogger.Printer appender) {
        boolean retVal = true;
        BigDecimal tmpLimit = null;
        tmpLimit = this.getLowerLimit();
        if (tmpLimit != null && value.subtract(tmpLimit).signum() == -1 && context.isDifferent(tmpLimit.doubleValue(), value.doubleValue())) {
            if (appender != null) {
                appender.println(value + " ! " + this.toString());
            }
            retVal = false;
        }
        if ((tmpLimit = this.getUpperLimit()) != null && value.subtract(tmpLimit).signum() == 1 && context.isDifferent(tmpLimit.doubleValue(), value.doubleValue())) {
            if (appender != null) {
                appender.println(value + " ! " + this.toString());
            }
            retVal = false;
        }
        return retVal;
    }

    final void appendToString(StringBuilder builder) {
        this.appendLeftPart(builder);
        this.appendMiddlePart(builder);
        this.appendRightPart(builder);
    }

    abstract int deriveAdjustmentExponent();

    abstract boolean doIntegerRounding();

    final int getAdjustmentExponentValue() {
        return this.myAdjustmentExponent;
    }

    final BigDecimal getCompensatedLowerLimit(BigDecimal compensation) {
        return this.myLowerLimit != null ? this.myLowerLimit.subtract(compensation) : null;
    }

    final BigDecimal getCompensatedLowerLimit(BigDecimal compensation, NumberContext precision) {
        return this.myLowerLimit != null ? precision.enforce(this.myLowerLimit.subtract(compensation)) : null;
    }

    final BigDecimal getCompensatedUpperLimit(BigDecimal compensation) {
        return this.myUpperLimit != null ? this.myUpperLimit.subtract(compensation) : null;
    }

    final BigDecimal getCompensatedUpperLimit(BigDecimal compensation, NumberContext precision) {
        return this.myUpperLimit != null ? precision.enforce(this.myUpperLimit.subtract(compensation)) : null;
    }

    boolean isClosedRange(BigDecimal lower, BigDecimal upper) {
        return this.myLowerLimit != null && this.myUpperLimit != null && this.myLowerLimit.compareTo(lower) == 0 && this.myUpperLimit.compareTo(upper) == 0;
    }

    boolean isInfeasible() {
        return this.myLowerLimit != null && this.myUpperLimit != null && this.myLowerLimit.compareTo(this.myUpperLimit) > 0;
    }
}

