/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.RoundingMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.OptimisationData;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.RowView;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.Stopwatch;
import org.ojalgo.type.context.NumberContext;

public abstract class GenericSolver
implements Optimisation.Solver {
    protected static final NumberContext ACCURACY = NumberContext.of(12, 14).withMode(RoundingMode.HALF_DOWN);
    public final Optimisation.Options options;
    private transient String myClassSimpleName = null;
    private final AtomicInteger myIterationsCount = new AtomicInteger(0);
    private Optimisation.State myState = Optimisation.State.UNEXPLORED;
    private final Stopwatch myStopwatch = new Stopwatch();

    private GenericSolver() {
        this(new Optimisation.Options());
    }

    protected GenericSolver(Optimisation.Options solverOptions) {
        ProgrammingError.throwIfNull((Object)solverOptions);
        this.options = solverOptions;
    }

    protected Optimisation.Result buildResult() {
        Access1D<?> solution = this.extractSolution();
        double value = this.evaluateFunction(solution);
        Optimisation.State state = this.getState();
        return new Optimisation.Result(state, value, solution);
    }

    protected final int countIterations() {
        return this.myIterationsCount.get();
    }

    protected final long countTime() {
        return this.myStopwatch.countMillis();
    }

    protected final void error(String messagePattern, Object ... arguments) {
        BasicLogger.error(messagePattern, arguments);
    }

    protected abstract double evaluateFunction(Access1D<?> var1);

    protected abstract Access1D<?> extractSolution();

    protected final String getClassSimpleName() {
        if (this.myClassSimpleName == null) {
            this.myClassSimpleName = this.getClass().getSimpleName();
        }
        return this.myClassSimpleName;
    }

    protected final CalendarDateDuration getDuration() {
        return this.myStopwatch.stop(CalendarDateUnit.SECOND);
    }

    protected Optimisation.State getState() {
        return this.myState;
    }

    protected final int incrementIterationsCount() {
        int iterationsDone = this.myIterationsCount.incrementAndGet();
        if (this.isLogProgress() && iterationsDone % 100000 == 0) {
            this.logProgress(iterationsDone, this.getClassSimpleName(), this.getDuration());
        }
        return iterationsDone;
    }

    protected final boolean isIterationAllowed() {
        if (this.myState.isFailure() || Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (this.myState.isFeasible()) {
            return this.countTime() < this.options.time_suffice && this.countIterations() < this.options.iterations_suffice;
        }
        return this.countTime() < this.options.time_abort && this.countIterations() < this.options.iterations_abort;
    }

    protected final boolean isLogDebug() {
        return this.options.logger_detailed && this.isLogProgress();
    }

    protected final boolean isLogOff() {
        return this.options.logger_appender == null || !this.options.logger_solver.isAssignableFrom(this.getClass());
    }

    protected final boolean isLogProgress() {
        return this.options.logger_appender != null && this.options.logger_solver.isAssignableFrom(this.getClass());
    }

    protected final void log() {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println();
        }
    }

    protected final void log(String descripttion, Access2D<?> matrix) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.printmtrx(descripttion, matrix, this.options.print);
        }
    }

    protected final void log(String messagePattern, Object ... arguments) {
        if (this.options.logger_appender != null) {
            this.options.logger_appender.println(messagePattern, arguments);
        }
    }

    protected void logProgress(int iterationsDone, String classSimpleName, CalendarDateDuration duration) {
        this.log("Done {} {} iterations in {}.", iterationsDone, classSimpleName, duration);
    }

    protected final void resetIterationsCount() {
        this.myIterationsCount.set(0);
        this.myStopwatch.reset();
    }

    protected final void setState(Optimisation.State state) {
        Objects.requireNonNull(state);
        this.myState = state;
    }

    public static abstract class Builder<B extends Builder<?, ?>, S extends GenericSolver> {
        protected static final PhysicalStore.Factory<Double, Primitive64Store> FACTORY = Primitive64Store.FACTORY;
        private final OptimisationData myData = new OptimisationData();

        protected static final void append(StringBuilder builder, String label, MatrixStore<Double> matrix) {
            if (builder != null && label != null && matrix != null) {
                builder.append("\n[");
                builder.append(label);
                builder.append("] = ");
                builder.append(Primitive64Matrix.FACTORY.copy(matrix));
            }
        }

        protected Builder() {
        }

        public final S build() {
            this.myData.validate();
            return this.doBuild(new Optimisation.Options());
        }

        public final S build(Optimisation.Options options) {
            ProgrammingError.throwIfNull((Object)options);
            this.myData.validate();
            return this.doBuild(options);
        }

        public int countAdditionalConstraints() {
            return this.myData.countAdditionalConstraints();
        }

        public int countConstraints() {
            return this.countEqualityConstraints() + this.countInequalityConstraints() + this.countAdditionalConstraints();
        }

        public int countEqualityConstraints() {
            return this.myData.countEqualityConstraints();
        }

        public int countInequalityConstraints() {
            return this.myData.countInequalityConstraints();
        }

        public int countVariables() {
            return this.myData.countVariables();
        }

        public B equalities(Access2D<Double> mtrxAE, Access1D<Double> mtrxBE) {
            this.myData.setEqualities(mtrxAE, mtrxBE);
            return (B)this;
        }

        public MatrixStore<Double> getAE() {
            return this.myData.getAE();
        }

        public MatrixStore<Double> getBE() {
            return this.myData.getBE();
        }

        public MatrixStore<Double> getC() {
            return this.myData.getObjective().getLinearFactors();
        }

        public boolean hasEqualityConstraints() {
            return this.myData.countEqualityConstraints() > 0;
        }

        public boolean hasInequalityConstraints() {
            return this.myData.countInequalityConstraints() > 0;
        }

        @Deprecated
        public boolean hasObjective() {
            return this.myData.getObjective() != null;
        }

        public void reset() {
            this.myData.reset();
        }

        public void splitEqualities() {
            if (this.hasEqualityConstraints()) {
                this.myData.addInequalities(this.myData.getAE(), this.myData.getBE());
                this.myData.addInequalities((MatrixStore<Double>)this.myData.getAE().negate(), (MatrixStore<Double>)this.myData.getBE().negate());
                this.myData.clearEqualities();
            }
        }

        public final String toString() {
            String simpleName = this.getClass().getSimpleName();
            StringBuilder retVal = new StringBuilder();
            retVal.append("<");
            retVal.append(simpleName);
            retVal.append(">");
            this.append(retVal);
            retVal.append("\n</");
            retVal.append(simpleName);
            retVal.append(">");
            return retVal.toString();
        }

        @Deprecated
        public final void validate() {
            this.myData.validate();
        }

        protected void append(StringBuilder builder) {
            Builder.append(builder, "AE", this.getAE());
            Builder.append(builder, "BE", this.getBE());
            Builder.append(builder, "AI", this.getAI());
            Builder.append(builder, "BI", this.getBI());
            Builder.append(builder, "C", this.getC());
        }

        protected abstract S doBuild(Optimisation.Options var1);

        protected MatrixStore<Double> getAI() {
            return this.myData.getAI();
        }

        protected SparseArray<Double> getAI(int row) {
            return this.myData.getAI(row);
        }

        protected RowsSupplier<Double> getAI(int ... rows) {
            return this.myData.getAI(rows);
        }

        protected MatrixStore<Double> getBI() {
            return this.myData.getBI();
        }

        protected double getBI(int row) {
            return this.myData.getBI(row);
        }

        protected <T extends MultiaryFunction.TwiceDifferentiable<Double>> T getObjective() {
            return this.myData.getObjective();
        }

        protected RowView<Double> getRowsAI() {
            return this.myData.getRowsAI();
        }

        protected B inequalities(Access2D<Double> mtrxAI, Access1D<Double> mtrxBI) {
            this.myData.setInequalities(mtrxAI, mtrxBI);
            return (B)this;
        }

        protected void setObjective(MultiaryFunction.TwiceDifferentiable<Double> objective) {
            this.myData.setObjective(objective);
        }
    }
}

