/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.SimpleAsset;
import org.ojalgo.data.domain.finance.portfolio.SimplePortfolio;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.TypeUtils;

abstract class EquilibriumModel
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient Primitive64Matrix myAssetReturns;
    private transient Primitive64Matrix myAssetVolatilities;
    private transient Primitive64Matrix myAssetWeights;
    private final MarketEquilibrium myMarketEquilibrium;
    private transient Scalar<?> myMeanReturn;
    private transient Scalar<?> myReturnVariance;

    protected EquilibriumModel(FinancePortfolio.Context portfolioContext) {
        this.myMarketEquilibrium = new MarketEquilibrium(portfolioContext.getCovariances());
    }

    protected EquilibriumModel(MarketEquilibrium marketEquilibrium) {
        this.myMarketEquilibrium = marketEquilibrium.copy();
    }

    @Override
    public final double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        Primitive64Matrix tmpAssetWeights = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{tmpWeights});
        Primitive64Matrix tmpAssetReturns = this.getAssetReturns();
        return this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public final double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        Primitive64Matrix tmpAssetWeights = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{tmpWeights});
        return this.calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public final Primitive64Matrix getAssetReturns() {
        if (this.myAssetReturns == null) {
            this.myAssetReturns = this.calculateAssetReturns();
        }
        return this.myAssetReturns;
    }

    @Override
    public final Primitive64Matrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = this.myMarketEquilibrium.toCorrelations();
        }
        return this.myAssetVolatilities;
    }

    public final Primitive64Matrix getAssetWeights() {
        if (this.myAssetWeights == null) {
            this.myAssetWeights = this.calculateAssetWeights();
        }
        return this.myAssetWeights;
    }

    @Override
    public final Primitive64Matrix getCorrelations() {
        return this.myMarketEquilibrium.toCorrelations();
    }

    @Override
    public final Primitive64Matrix getCovariances() {
        return this.myMarketEquilibrium.getCovariances();
    }

    public final MarketEquilibrium getMarketEquilibrium() {
        return this.myMarketEquilibrium.copy();
    }

    @Override
    public final double getMeanReturn() {
        if (this.myMeanReturn == null) {
            Primitive64Matrix tmpAssetWeights = this.getAssetWeights();
            Primitive64Matrix tmpAssetReturns = this.getAssetReturns();
            if (tmpAssetWeights != null && tmpAssetReturns != null) {
                this.myMeanReturn = this.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns);
            }
        }
        return this.myMeanReturn.doubleValue();
    }

    @Override
    public final double getReturnVariance() {
        if (this.myReturnVariance == null) {
            this.myReturnVariance = this.calculatePortfolioVariance(this.getAssetWeights());
        }
        return this.myReturnVariance.doubleValue();
    }

    public final Scalar<?> getRiskAversion() {
        return this.myMarketEquilibrium.getRiskAversion();
    }

    public final String[] getSymbols() {
        return this.myMarketEquilibrium.getAssetKeys();
    }

    @Override
    public final List<BigDecimal> getWeights() {
        Primitive64Matrix tmpAssetWeights = this.getAssetWeights();
        if (tmpAssetWeights != null) {
            return Array1D.BIG.copy((Access1D)tmpAssetWeights);
        }
        return null;
    }

    public final void setRiskAversion(Comparable<?> factor) {
        this.myMarketEquilibrium.setRiskAversion(factor);
        this.reset();
    }

    @Override
    public int size() {
        return this.myMarketEquilibrium.size();
    }

    public final List<SimpleAsset> toSimpleAssets() {
        Primitive64Matrix tmpReturns = this.getAssetReturns();
        Primitive64Matrix tmpCovariances = this.getCovariances();
        List<BigDecimal> tmpWeights = this.getWeights();
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpReturns.doubleValue(i, 0L);
            double tmpVolatility = PrimitiveMath.SQRT.invoke(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            retVal.add(new SimpleAsset(Double.valueOf(tmpMeanReturn), Double.valueOf(tmpVolatility), tmpWeight));
        }
        return retVal;
    }

    public final SimplePortfolio toSimplePortfolio() {
        return new SimplePortfolio(this.getCorrelations(), this.toSimpleAssets());
    }

    @Override
    public String toString() {
        return TypeUtils.format("RAF={} {}", this.getRiskAversion().toString(), super.toString());
    }

    protected abstract Primitive64Matrix calculateAssetReturns();

    protected final Primitive64Matrix calculateAssetReturns(Primitive64Matrix aWeightsVctr) {
        return this.myMarketEquilibrium.calculateAssetReturns(aWeightsVctr);
    }

    protected abstract Primitive64Matrix calculateAssetWeights();

    protected final Primitive64Matrix calculateAssetWeights(Primitive64Matrix aReturnsVctr) {
        return this.myMarketEquilibrium.calculateAssetWeights(aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioReturn(Primitive64Matrix aWeightsVctr, Primitive64Matrix aReturnsVctr) {
        return MarketEquilibrium.calculatePortfolioReturn(aWeightsVctr, aReturnsVctr);
    }

    protected final Scalar<?> calculatePortfolioVariance(Primitive64Matrix aWeightsVctr) {
        return this.myMarketEquilibrium.calculatePortfolioVariance(aWeightsVctr);
    }

    protected final void calibrate(Primitive64Matrix aWeightsVctr, Primitive64Matrix aReturnsVctr) {
        Scalar<?> tmpRiskAvesrion = this.myMarketEquilibrium.calculateImpliedRiskAversion(aWeightsVctr, aReturnsVctr);
        this.setRiskAversion((Comparable)tmpRiskAvesrion.get());
    }

    @Override
    protected void reset() {
        this.myAssetWeights = null;
        this.myAssetReturns = null;
        this.myMeanReturn = null;
        this.myReturnVariance = null;
    }

    final boolean isDefaultRiskAversion() {
        return this.myMarketEquilibrium.isDefaultRiskAversion();
    }
}

