/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.RationalFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.RationalAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public class RationalArray
extends ScalarArray<RationalNumber> {
    public static final DenseArray.Factory<RationalNumber> FACTORY = new DenseArray.Factory<RationalNumber>(){

        @Override
        public AggregatorSet<RationalNumber> aggregator() {
            return RationalAggregator.getSet();
        }

        @Override
        public FunctionSet<RationalNumber> function() {
            return RationalFunction.getSet();
        }

        @Override
        public Scalar.Factory<RationalNumber> scalar() {
            return RationalNumber.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<RationalNumber> makeDenseArray(long size) {
            return RationalArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(RationalNumber.class);

    public static final RationalArray make(int size) {
        return new RationalArray(size);
    }

    public static final RationalArray wrap(RationalNumber ... data) {
        return new RationalArray(data);
    }

    protected RationalArray(int size) {
        super(FACTORY, size);
    }

    protected RationalArray(RationalNumber[] data) {
        super(FACTORY, (Scalar[])data);
    }
}

