/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.rest;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.datastreams.options.action.GetDataStreamOptionsAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetDataStreamOptionsAction
extends BaseRestHandler {
    private static final Set<String> CAPABILITIES = Set.of("failure_store.lifecycle");

    public String getName() {
        return "get_data_stream_options_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_data_stream/{name}/_options"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        GetDataStreamOptionsAction.Request getDataStreamOptionsRequest = new GetDataStreamOptionsAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), Strings.splitStringByCommaToArray((String)request.param("name")));
        getDataStreamOptionsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getDataStreamOptionsRequest.indicesOptions()));
        return channel -> client.execute(GetDataStreamOptionsAction.INSTANCE, (ActionRequest)getDataStreamOptionsRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    public Set<String> supportedCapabilities() {
        return CAPABILITIES;
    }
}

