/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.util.Map;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.PosixConstants;
import org.elasticsearch.nativeaccess.PosixNativeAccess;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.lib.LinuxCLibrary;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;

class LinuxNativeAccess
extends PosixNativeAccess {
    private static final int STATX_BLOCKS = 1024;
    static final int SECCOMP_SET_MODE_FILTER = 1;
    static final int SECCOMP_FILTER_FLAG_TSYNC = 1;
    static final int PR_GET_NO_NEW_PRIVS = 39;
    static final int PR_SET_NO_NEW_PRIVS = 38;
    static final int PR_GET_SECCOMP = 21;
    static final int PR_SET_SECCOMP = 22;
    static final long SECCOMP_MODE_FILTER = 2L;
    static final int BPF_LD = 0;
    static final int BPF_W = 0;
    static final int BPF_ABS = 32;
    static final int BPF_JMP = 5;
    static final int BPF_JEQ = 16;
    static final int BPF_JGE = 48;
    static final int BPF_JGT = 32;
    static final int BPF_RET = 6;
    static final int BPF_K = 0;
    static final int SECCOMP_RET_ERRNO = 327680;
    static final int SECCOMP_RET_DATA = 65535;
    static final int SECCOMP_RET_ALLOW = 0x7FFF0000;
    static final int EACCES = 13;
    static final int EFAULT = 14;
    static final int EINVAL = 22;
    static final int ENOSYS = 38;
    static final int SECCOMP_DATA_NR_OFFSET = 0;
    static final int SECCOMP_DATA_ARCH_OFFSET = 4;
    private static final Map<String, Arch> ARCHITECTURES = Map.of("amd64", new Arch(-1073741762, 0x3FFFFFFF, 57, 58, 59, 322, 317), "aarch64", new Arch(-1073741641, -1, 1079, 1071, 221, 281, 277));
    private final LinuxCLibrary linuxLibc;
    private final Systemd systemd;

    static LinuxCLibrary.SockFilter BPF_STMT(int code, int k) {
        return new LinuxCLibrary.SockFilter((short)code, 0, 0, k);
    }

    static LinuxCLibrary.SockFilter BPF_JUMP(int code, int k, int jt, int jf) {
        return new LinuxCLibrary.SockFilter((short)code, (byte)jt, (byte)jf, k);
    }

    LinuxNativeAccess(NativeLibraryProvider libraryProvider) {
        super("Linux", libraryProvider, new PosixConstants(-1L, 9, 1, 8, 64, 144, 48, 64));
        this.linuxLibc = libraryProvider.getLibrary(LinuxCLibrary.class);
        String socketPath = System.getenv("NOTIFY_SOCKET");
        if (socketPath == null) {
            this.systemd = null;
        } else {
            logger.debug("Systemd socket path: {}", new Object[]{socketPath});
            CloseableByteBuffer buffer = this.newSharedBuffer(64);
            this.systemd = new Systemd(libraryProvider.getLibrary(PosixCLibrary.class), socketPath, buffer);
        }
    }

    @Override
    protected long getMaxThreads() {
        int rlimit_nproc = 6;
        return this.getRLimit(6, "max number of threads");
    }

    @Override
    public Systemd systemd() {
        return this.systemd;
    }

    @Override
    protected void logMemoryLimitInstructions() {
        String user = System.getProperty("user.name");
        logger.warn("These can be adjusted by modifying /etc/security/limits.conf, for example:\n\t# allow user '{}' mlockall\n\t{} soft memlock unlimited\n\t{} hard memlock unlimited", new Object[]{user, user, user});
        logger.warn("If you are logged in interactively, you will have to re-login for the new limits to take effect.");
    }

    @Override
    protected boolean nativePreallocate(int fd, long currentSize, long newSize) {
        int rc = this.linuxLibc.fallocate(fd, 0, currentSize, newSize - currentSize);
        if (rc != 0) {
            logger.warn("fallocate failed: " + this.libc.strerror(this.libc.errno()));
            return false;
        }
        return true;
    }

    @Override
    public void tryInstallExecSandbox() {
        String archId = System.getProperty("os.arch");
        Arch arch = ARCHITECTURES.get(archId);
        if (arch == null) {
            throw new UnsupportedOperationException("seccomp unavailable: '" + archId + "' architecture unsupported");
        }
        int bogusArg = -140219812;
        long ret = this.linuxLibc.syscall(arch.seccomp, -140219812, 0, 0L);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: seccomp(BOGUS_OPERATION) returned " + ret);
        }
        int errno = this.libc.errno();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("seccomp(BOGUS_OPERATION): " + this.libc.strerror(errno));
            }
        }
        ret = this.linuxLibc.syscall(arch.seccomp, 1, -140219812, 0L);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: seccomp(SECCOMP_SET_MODE_FILTER, BOGUS_FLAG) returned " + ret);
        }
        errno = this.libc.errno();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("seccomp(SECCOMP_SET_MODE_FILTER, BOGUS_FLAG): " + this.libc.strerror(errno));
            }
        }
        ret = this.linuxLibc.prctl(-140219812, 0L, 0L, 0L, 0L);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: prctl(BOGUS_OPTION) returned " + ret);
        }
        errno = this.libc.errno();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("prctl(BOGUS_OPTION): " + this.libc.strerror(errno));
            }
        }
        switch (this.linuxLibc.prctl(39, 0L, 0L, 0L, 0L)) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                errno = this.libc.errno();
                if (errno == 22) {
                    throw new UnsupportedOperationException("seccomp unavailable: requires kernel 3.5+ with CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER compiled in");
                }
                throw new UnsupportedOperationException("prctl(PR_GET_NO_NEW_PRIVS): " + this.libc.strerror(errno));
            }
        }
        switch (this.linuxLibc.prctl(21, 0L, 0L, 0L, 0L)) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                errno = this.libc.errno();
                if (errno == 22) {
                    throw new UnsupportedOperationException("seccomp unavailable: CONFIG_SECCOMP not compiled into kernel, CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER are needed");
                }
                throw new UnsupportedOperationException("prctl(PR_GET_SECCOMP): " + this.libc.strerror(errno));
            }
        }
        if (this.linuxLibc.prctl(22, 2L, 0L, 0L, 0L) != 0) {
            errno = this.libc.errno();
            switch (errno) {
                case 14: {
                    break;
                }
                case 22: {
                    throw new UnsupportedOperationException("seccomp unavailable: CONFIG_SECCOMP_FILTER not compiled into kernel, CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER are needed");
                }
                default: {
                    throw new UnsupportedOperationException("prctl(PR_SET_SECCOMP): " + this.libc.strerror(errno));
                }
            }
        }
        if (this.linuxLibc.prctl(38, 1L, 0L, 0L, 0L) != 0) {
            throw new UnsupportedOperationException("prctl(PR_SET_NO_NEW_PRIVS): " + this.libc.strerror(this.libc.errno()));
        }
        if (this.linuxLibc.prctl(39, 0L, 0L, 0L, 0L) != 1) {
            throw new UnsupportedOperationException("seccomp filter did not really succeed: prctl(PR_GET_NO_NEW_PRIVS): " + this.libc.strerror(this.libc.errno()));
        }
        LinuxCLibrary.SockFilter[] insns = new LinuxCLibrary.SockFilter[]{LinuxNativeAccess.BPF_STMT(32, 4), LinuxNativeAccess.BPF_JUMP(21, arch.audit, 0, 7), LinuxNativeAccess.BPF_STMT(32, 0), LinuxNativeAccess.BPF_JUMP(37, arch.limit, 5, 0), LinuxNativeAccess.BPF_JUMP(21, arch.fork, 4, 0), LinuxNativeAccess.BPF_JUMP(21, arch.vfork, 3, 0), LinuxNativeAccess.BPF_JUMP(21, arch.execve, 2, 0), LinuxNativeAccess.BPF_JUMP(21, arch.execveat, 1, 0), LinuxNativeAccess.BPF_STMT(6, 0x7FFF0000), LinuxNativeAccess.BPF_STMT(6, 327693)};
        LinuxCLibrary.SockFProg prog = this.linuxLibc.newSockFProg(insns);
        boolean method = true;
        if (this.linuxLibc.syscall(arch.seccomp, 1, 1, prog.address()) != 0L) {
            method = false;
            int errno1 = this.libc.errno();
            if (logger.isDebugEnabled()) {
                logger.debug("seccomp(SECCOMP_SET_MODE_FILTER): {}, falling back to prctl(PR_SET_SECCOMP)...", new Object[]{this.libc.strerror(errno1)});
            }
            if (this.linuxLibc.prctl(22, 2L, prog.address(), 0L, 0L) != 0) {
                int errno2 = this.libc.errno();
                throw new UnsupportedOperationException("seccomp(SECCOMP_SET_MODE_FILTER): " + this.libc.strerror(errno1) + ", prctl(PR_SET_SECCOMP): " + this.libc.strerror(errno2));
            }
        }
        if (this.linuxLibc.prctl(21, 0L, 0L, 0L, 0L) != 2) {
            throw new UnsupportedOperationException("seccomp filter installation did not really succeed. seccomp(PR_GET_SECCOMP): " + this.libc.strerror(this.libc.errno()));
        }
        logger.debug("Linux seccomp filter installation successful, threads: [{}]", new Object[]{method ? "all" : "app"});
        this.execSandboxState = method ? NativeAccess.ExecSandboxState.ALL_THREADS : NativeAccess.ExecSandboxState.EXISTING_THREADS;
    }

    record Arch(int audit, int limit, int fork, int vfork, int execve, int execveat, int seccomp) {
    }
}

