/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class BinaryPredicate<T, U, R, F extends PredicateBiFunction<T, U, R>>
extends BinaryScalarFunction {
    private final F function;

    protected BinaryPredicate(Source source, Expression left, Expression right, F function) {
        super(source, left, right);
        this.function = function;
    }

    public R fold(FoldContext ctx) {
        return this.function().apply((Object)this.left().fold(ctx), (Object)this.right().fold(ctx));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.function.symbol());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryPredicate other = (BinaryPredicate)obj;
        return Objects.equals(this.symbol(), other.symbol()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public String symbol() {
        return this.function.symbol();
    }

    public F function() {
        return this.function;
    }

    @Override
    public String nodeString() {
        return this.left().nodeString() + " " + this.symbol() + " " + this.right().nodeString();
    }
}

