/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.StreamsMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.streams.logs.StreamsStatusAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportStreamsStatusAction
extends TransportLocalClusterStateAction<StreamsStatusAction.Request, StreamsStatusAction.Response> {
    @Inject
    public TransportStreamsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(StreamsStatusAction.INSTANCE.name(), clusterService, transportService, actionFilters, null, (Executor)threadPool.executor("management"));
    }

    protected ClusterBlockException checkBlock(StreamsStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void localClusterStateOperation(Task task, StreamsStatusAction.Request request, ClusterState state, ActionListener<StreamsStatusAction.Response> listener) {
        StreamsMetadata streamsState = (StreamsMetadata)state.metadata().custom("streams", (Metadata.Custom)StreamsMetadata.EMPTY);
        boolean logsEnabled = streamsState.isLogsEnabled();
        StreamsStatusAction.Response response = new StreamsStatusAction.Response(logsEnabled);
        listener.onResponse((Object)response);
    }
}

