/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.Comparator;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.elasticsearch.search.suggest.SortBy;

public class DirectSpellcheckerSettings {
    public static final SuggestMode DEFAULT_SUGGEST_MODE = SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
    public static final float DEFAULT_ACCURACY = 0.5f;
    public static final SortBy DEFAULT_SORT = SortBy.SCORE;
    public static final StringDistance DEFAULT_STRING_DISTANCE = DirectSpellChecker.INTERNAL_LEVENSHTEIN;
    public static final int DEFAULT_MAX_EDITS = 2;
    public static final int DEFAULT_MAX_INSPECTIONS = 5;
    public static final float DEFAULT_MAX_TERM_FREQ = 0.01f;
    public static final int DEFAULT_PREFIX_LENGTH = 1;
    public static final int DEFAULT_MIN_WORD_LENGTH = 4;
    public static final float DEFAULT_MIN_DOC_FREQ = 0.0f;
    private SuggestMode suggestMode = DEFAULT_SUGGEST_MODE;
    private float accuracy = 0.5f;
    private SortBy sort = DEFAULT_SORT;
    private StringDistance stringDistance = DEFAULT_STRING_DISTANCE;
    private int maxEdits = 2;
    private int maxInspections = 5;
    private float maxTermFreq = 0.01f;
    private int prefixLength = 1;
    private int minWordLength = 4;
    private float minDocFreq = 0.0f;
    private static final Comparator<SuggestWord> LUCENE_FREQUENCY = new SuggestWordFrequencyComparator();
    private static final Comparator<SuggestWord> SCORE_COMPARATOR = SuggestWordQueue.DEFAULT_COMPARATOR;

    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    public void suggestMode(SuggestMode suggestMode) {
        this.suggestMode = suggestMode;
    }

    public float accuracy() {
        return this.accuracy;
    }

    public void accuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public SortBy sort() {
        return this.sort;
    }

    public void sort(SortBy sort) {
        this.sort = sort;
    }

    public StringDistance stringDistance() {
        return this.stringDistance;
    }

    public void stringDistance(StringDistance distance) {
        this.stringDistance = distance;
    }

    public int maxEdits() {
        return this.maxEdits;
    }

    public void maxEdits(int maxEdits) {
        this.maxEdits = maxEdits;
    }

    public int maxInspections() {
        return this.maxInspections;
    }

    public void maxInspections(int maxInspections) {
        this.maxInspections = maxInspections;
    }

    public float maxTermFreq() {
        return this.maxTermFreq;
    }

    public void maxTermFreq(float maxTermFreq) {
        this.maxTermFreq = maxTermFreq;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public void prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public int minWordLength() {
        return this.minWordLength;
    }

    public void minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
    }

    public float minDocFreq() {
        return this.minDocFreq;
    }

    public void minDocFreq(float minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public DirectSpellChecker createDirectSpellChecker() {
        DirectSpellChecker directSpellChecker = new DirectSpellChecker();
        directSpellChecker.setAccuracy(this.accuracy());
        Comparator<SuggestWord> comparator = switch (this.sort()) {
            default -> throw new IncompatibleClassChangeError();
            case SortBy.SCORE -> SCORE_COMPARATOR;
            case SortBy.FREQUENCY -> LUCENE_FREQUENCY;
        };
        directSpellChecker.setComparator(comparator);
        directSpellChecker.setDistance(this.stringDistance());
        directSpellChecker.setMaxEdits(this.maxEdits());
        directSpellChecker.setMaxInspections(this.maxInspections());
        directSpellChecker.setMaxQueryFrequency(this.maxTermFreq());
        directSpellChecker.setMinPrefix(this.prefixLength());
        directSpellChecker.setMinQueryLength(this.minWordLength());
        directSpellChecker.setThresholdFrequency(this.minDocFreq());
        directSpellChecker.setLowerCaseTerms(false);
        return directSpellChecker;
    }

    public String toString() {
        return "[suggestMode=" + String.valueOf(this.suggestMode) + ",sort=" + String.valueOf(this.sort) + ",stringDistance=" + String.valueOf(this.stringDistance) + ",accuracy=" + this.accuracy + ",maxEdits=" + this.maxEdits + ",maxInspections=" + this.maxInspections + ",maxTermFreq=" + this.maxTermFreq + ",prefixLength=" + this.prefixLength + ",minWordLength=" + this.minWordLength + ",minDocFreq=" + this.minDocFreq + "]";
    }
}

