/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.SamplingContext;

public class RandomSamplerAggregatorFactory
extends AggregatorFactory {
    private final int seed;
    private final Integer shardSeed;
    private final double probability;
    private final SamplingContext samplingContext;

    RandomSamplerAggregatorFactory(String name, int seed, Integer shardSeed, double probability, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.probability = probability;
        this.seed = seed;
        this.samplingContext = new SamplingContext(probability, seed, shardSeed);
        this.shardSeed = shardSeed;
    }

    @Override
    public Optional<SamplingContext> getSamplingContext() {
        return Optional.of(this.samplingContext);
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new RandomSamplerAggregator(this.name, this.seed, this.shardSeed, this.probability, this.factories, this.context, parent, cardinality, metadata);
    }
}

