/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    public TermBasedFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
        this.failIfNotIndexed();
        BytesRef valueForSearch = this.indexedValueForSearch(value);
        if (valueForSearch.length == 0) {
            return this.termQuery(value, context);
        }
        return AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), valueForSearch));
    }

    @Override
    public boolean mayExistInIndex(SearchExecutionContext context) {
        return context.fieldExistsInIndex(this.name());
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.failIfNotIndexed();
        return new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        this.failIfNotIndexed();
        BytesRef[] bytesRefs = (BytesRef[])values.stream().map(this::indexedValueForSearch).toArray(BytesRef[]::new);
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

