/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class GatewayService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(GatewayService.class);
    public static final Setting<Integer> EXPECTED_DATA_NODES_SETTING = Setting.intSetting("gateway.expected_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RECOVER_AFTER_TIME_SETTING = Setting.positiveTimeSetting("gateway.recover_after_time", TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_DATA_NODES_SETTING = Setting.intSetting("gateway.recover_after_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    static final TimeValue DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET = TimeValue.timeValueMinutes((long)5L);
    private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
    private final ThreadPool threadPool;
    private final RerouteService rerouteService;
    private final ClusterService clusterService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    volatile PendingStateRecovery currentPendingStateRecovery;
    private static final String TASK_SOURCE = "local-gateway-elected-state";

    @Inject
    public GatewayService(Settings settings, RerouteService rerouteService, ClusterService clusterService, ShardRoutingRoleStrategy shardRoutingRoleStrategy, ThreadPool threadPool) {
        this.rerouteService = rerouteService;
        this.clusterService = clusterService;
        this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
        this.threadPool = threadPool;
        this.expectedDataNodes = EXPECTED_DATA_NODES_SETTING.get(settings);
        this.recoverAfterTime = RECOVER_AFTER_TIME_SETTING.exists(settings) ? RECOVER_AFTER_TIME_SETTING.get(settings) : (this.expectedDataNodes >= 0 ? DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET : null);
        this.recoverAfterDataNodes = RECOVER_AFTER_DATA_NODES_SETTING.get(settings);
    }

    @Override
    protected void doStart() {
        if (DiscoveryNode.isMasterNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        ClusterState state = event.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            return;
        }
        if (!state.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        long currentTerm = state.term();
        PendingStateRecovery existingPendingStateRecovery = this.currentPendingStateRecovery;
        if (existingPendingStateRecovery == null || existingPendingStateRecovery.expectedTerm < currentTerm) {
            this.currentPendingStateRecovery = new PendingStateRecovery(currentTerm);
        }
        this.currentPendingStateRecovery.onDataNodeSize(nodes.getDataNodes().size());
    }

    TimeValue recoverAfterTime() {
        return this.recoverAfterTime;
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    class PendingStateRecovery {
        private final long expectedTerm;
        @Nullable
        private Scheduler.ScheduledCancellable scheduledRecovery;
        private final AtomicBoolean taskSubmitted = new AtomicBoolean();

        PendingStateRecovery(long expectedTerm) {
            this.expectedTerm = expectedTerm;
        }

        void onDataNodeSize(int currentDataNodeSize) {
            if (GatewayService.this.recoverAfterDataNodes != -1 && currentDataNodeSize < GatewayService.this.recoverAfterDataNodes) {
                logger.debug("not recovering from gateway, nodes_size (data) [{}] < recover_after_data_nodes [{}]", (Object)currentDataNodeSize, (Object)GatewayService.this.recoverAfterDataNodes);
                this.cancelScheduledRecovery();
            } else {
                this.maybePerformOrScheduleRecovery(currentDataNodeSize);
            }
        }

        void maybePerformOrScheduleRecovery(int currentDataNodeSize) {
            if (GatewayService.this.expectedDataNodes != -1 && GatewayService.this.expectedDataNodes <= currentDataNodeSize) {
                logger.debug("performing state recovery of term [{}], expected data nodes [{}] is reached", (Object)this.expectedTerm, (Object)GatewayService.this.expectedDataNodes);
                this.cancelScheduledRecovery();
                this.runRecoveryImmediately();
            } else if (GatewayService.this.recoverAfterTime == null) {
                logger.debug("performing state recovery of term [{}], no delay time is configured", (Object)this.expectedTerm);
                this.cancelScheduledRecovery();
                this.runRecoveryImmediately();
            } else if (this.scheduledRecovery == null) {
                logger.info("delaying initial state recovery for [{}] of term [{}]. expecting [{}] data nodes, but only have [{}]", (Object)GatewayService.this.recoverAfterTime, (Object)this.expectedTerm, (Object)GatewayService.this.expectedDataNodes, (Object)currentDataNodeSize);
                this.scheduledRecovery = GatewayService.this.threadPool.schedule(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("delayed state recovery of term [" + PendingStateRecovery.this.expectedTerm + "] failed", (Throwable)e);
                    }

                    @Override
                    protected void doRun() {
                        PendingStateRecovery existingPendingStateRecovery = GatewayService.this.currentPendingStateRecovery;
                        if (PendingStateRecovery.this == existingPendingStateRecovery) {
                            PendingStateRecovery.this.runRecoveryImmediately();
                        } else {
                            logger.debug("skip scheduled state recovery since a new one of term [{}] has started", (Object)existingPendingStateRecovery.expectedTerm);
                        }
                    }
                }, GatewayService.this.recoverAfterTime, GatewayService.this.threadPool.generic());
            } else {
                logger.debug("state recovery is in already scheduled for term [{}]", (Object)this.expectedTerm);
            }
        }

        void runRecoveryImmediately() {
            if (this.taskSubmitted.compareAndSet(false, true)) {
                GatewayService.this.submitUnbatchedTask(GatewayService.TASK_SOURCE, new RecoverStateUpdateTask(this.expectedTerm));
            } else {
                logger.debug("state recovery task is already submitted");
            }
        }

        void cancelScheduledRecovery() {
            if (this.scheduledRecovery != null) {
                this.scheduledRecovery.cancel();
                this.scheduledRecovery = null;
            }
        }
    }

    class RecoverStateUpdateTask
    extends ClusterStateUpdateTask {
        private final long expectedTerm;

        RecoverStateUpdateTask(long expectedTerm) {
            this.expectedTerm = expectedTerm;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            if (!currentState.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
                logger.debug("cluster is already recovered");
                return currentState;
            }
            if (this.expectedTerm != currentState.term()) {
                logger.debug("skip state recovery since current term [{}] != expected term [{}]", (Object)currentState.term(), (Object)this.expectedTerm);
                return currentState;
            }
            return ClusterStateUpdaters.removeStateNotRecoveredBlock(ClusterStateUpdaters.updateRoutingTable(currentState, GatewayService.this.shardRoutingRoleStrategy));
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            logger.info("recovered [{}] indices into cluster_state", (Object)newState.metadata().indices().size());
            GatewayService.this.rerouteService.reroute("state recovered", Priority.NORMAL, ActionListener.noop());
        }

        @Override
        public void onFailure(Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.INFO, () -> "unexpected failure during [local-gateway-elected-state]", (Throwable)e);
        }
    }
}

