/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.elasticsearch.common.MacAddressProvider;
import org.elasticsearch.common.UUIDGenerator;

class TimeBasedUUIDGenerator
implements UUIDGenerator {
    protected final AtomicInteger sequenceNumber;
    protected final AtomicLong lastTimestamp;
    protected final Supplier<Long> timestampSupplier;
    private static final byte[] SECURE_MUNGED_ADDRESS = MacAddressProvider.getSecureMungedAddress();
    private static final Base64.Encoder BASE_64_NO_PADDING;
    static final int SIZE_IN_BYTES = 15;
    private final byte[] macAddress;

    TimeBasedUUIDGenerator(Supplier<Long> timestampSupplier, Supplier<Integer> sequenceIdSupplier, Supplier<byte[]> macAddressSupplier) {
        this.timestampSupplier = timestampSupplier;
        this.macAddress = macAddressSupplier.get();
        this.sequenceNumber = new AtomicInteger(sequenceIdSupplier.get());
        this.lastTimestamp = new AtomicLong(0L);
    }

    protected byte[] macAddress() {
        return this.macAddress;
    }

    @Override
    public String getBase64UUID() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = this.lastTimestamp.accumulateAndGet(this.timestampSupplier.get(), sequenceId == 0 ? (lastTimestamp, currentTimeMillis) -> Math.max(lastTimestamp, currentTimeMillis) + 1L : Math::max);
        byte[] uuidBytes = new byte[15];
        int i = 0;
        uuidBytes[i++] = (byte)sequenceId;
        uuidBytes[i++] = (byte)(sequenceId >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 16);
        uuidBytes[i++] = (byte)(timestamp >>> 24);
        uuidBytes[i++] = (byte)(timestamp >>> 32);
        uuidBytes[i++] = (byte)(timestamp >>> 40);
        byte[] macAddress = this.macAddress();
        assert (macAddress.length == 6);
        System.arraycopy(macAddress, 0, uuidBytes, i, macAddress.length);
        i += macAddress.length;
        uuidBytes[i++] = (byte)(timestamp >>> 8);
        uuidBytes[i++] = (byte)(sequenceId >>> 8);
        uuidBytes[i++] = (byte)timestamp;
        assert (i == uuidBytes.length);
        return BASE_64_NO_PADDING.encodeToString(uuidBytes);
    }

    static {
        assert (SECURE_MUNGED_ADDRESS.length == 6);
        BASE_64_NO_PADDING = Base64.getUrlEncoder().withoutPadding();
    }
}

