/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.RelocationFailureInfo;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.settings.Setting;

public class MaxRetryAllocationDecider
extends AllocationDecider {
    public static final Setting<Integer> SETTING_ALLOCATION_MAX_RETRY = Setting.intSetting("index.allocation.max_retries", 5, 0, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.NotCopyableOnResize);
    private static final String RETRY_FAILED_API = "POST /_cluster/reroute?retry_failed&metric=none";
    public static final String NAME = "max_retry";
    private static final Decision YES_NO_FAILURES = Decision.single(Decision.Type.YES, "max_retry", "shard has no previous failures", new Object[0]);
    private static final Decision YES_SIMULATING = Decision.single(Decision.Type.YES, "max_retry", "previous failures ignored when simulating", new Object[0]);

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        int numFailedRelocations;
        int numFailedAllocations;
        if (allocation.isSimulating()) {
            return YES_SIMULATING;
        }
        int maxRetries = SETTING_ALLOCATION_MAX_RETRY.get(allocation.metadata().getIndexSafe(shardRouting.index()).getSettings());
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        int n = numFailedAllocations = unassignedInfo == null ? 0 : unassignedInfo.failedAllocations();
        if (numFailedAllocations > 0) {
            Decision decision = numFailedAllocations >= maxRetries ? Decision.NO : Decision.YES;
            return allocation.debugDecision() ? MaxRetryAllocationDecider.debugDecision(decision, unassignedInfo, numFailedAllocations, maxRetries) : decision;
        }
        RelocationFailureInfo relocationFailureInfo = shardRouting.relocationFailureInfo();
        int n2 = numFailedRelocations = relocationFailureInfo == null ? 0 : relocationFailureInfo.failedRelocations();
        if (numFailedRelocations > 0) {
            Decision decision = numFailedRelocations >= maxRetries ? Decision.NO : Decision.YES;
            return allocation.debugDecision() ? MaxRetryAllocationDecider.debugDecision(decision, relocationFailureInfo, numFailedRelocations, maxRetries) : decision;
        }
        return YES_NO_FAILURES;
    }

    private static Decision debugDecision(Decision decision, UnassignedInfo info, int numFailedAllocations, int maxRetries) {
        if (decision.type() == Decision.Type.NO) {
            return Decision.single(Decision.Type.NO, NAME, "shard has exceeded the maximum number of retries [%d] on failed allocation attempts - manually call [%s] to retry, and for more information, see [%s] [%s]", new Object[]{maxRetries, RETRY_FAILED_API, ReferenceDocs.ALLOCATION_EXPLAIN_MAX_RETRY, info.toString()});
        }
        return Decision.single(Decision.Type.YES, NAME, "shard has failed allocating [%d] times but [%d] retries are allowed", numFailedAllocations, maxRetries);
    }

    private static Decision debugDecision(Decision decision, RelocationFailureInfo info, int numFailedRelocations, int maxRetries) {
        if (decision.type() == Decision.Type.NO) {
            return Decision.single(Decision.Type.NO, NAME, "shard has exceeded the maximum number of retries [%d] on failed relocation attempts - manually call [%s] to retry, [%s]", maxRetries, RETRY_FAILED_API, info.toString());
        }
        return Decision.single(Decision.Type.YES, NAME, "shard has failed relocating [%d] times but [%d] retries are allowed", numFailedRelocations, maxRetries);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + String.valueOf(shardRouting);
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }
}

