/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record RelocationFailureInfo(int failedRelocations) implements ToXContentFragment,
Writeable
{
    public static final RelocationFailureInfo NO_FAILURES = new RelocationFailureInfo(0);

    public RelocationFailureInfo {
        assert (failedRelocations >= 0) : "Expect non-negative failures count, got: " + failedRelocations;
    }

    public static RelocationFailureInfo readFrom(StreamInput in) throws IOException {
        int failures = in.readVInt();
        return failures == 0 ? NO_FAILURES : new RelocationFailureInfo(failures);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.failedRelocations);
    }

    public RelocationFailureInfo incFailedRelocations() {
        return new RelocationFailureInfo(this.failedRelocations + 1);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("relocation_failure_info");
        builder.field("failed_attempts", this.failedRelocations);
        builder.endObject();
        return builder;
    }

    @Override
    public String toString() {
        return "failed_attempts[" + this.failedRelocations + "]";
    }
}

