/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.JoinReason;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.threadpool.ThreadPool;

public class JoinReasonService {
    private final LongSupplier relativeTimeInMillisSupplier;
    private Object discoveryNodes;
    private final Map<String, TrackedNode> trackedNodes = ConcurrentCollections.newConcurrentMap();
    private static final long NOT_REMOVED = -1L;
    private static final TrackedNode UNKNOWN_NODE = new TrackedNode(){

        @Override
        public TrackedNode present(String ephemeralId) {
            return new PresentNode(ephemeralId, 0);
        }

        @Override
        public TrackedNode absent(long currentTimeMillis, @Nullable DiscoveryNode masterNode) {
            assert (false);
            return this;
        }

        @Override
        public TrackedNode withRemovalReason(String removalReason) {
            assert (false);
            return this;
        }

        @Override
        public JoinReason getJoinReason(long currentTimeMillis, String joiningNodeEphemeralId, Coordinator.Mode currentMode) {
            if (currentMode == Coordinator.Mode.CANDIDATE) {
                return COMPLETING_ELECTION;
            }
            return NEW_NODE_JOINING;
        }

        @Override
        public long getRemovalAgeMillis(long currentTimeMillis) {
            return -1L;
        }
    };
    private static final JoinReason COMPLETING_ELECTION = new JoinReason("completing election", null);
    private static final JoinReason NEW_NODE_JOINING = new JoinReason("joining", null);
    private static final JoinReason KNOWN_NODE_REJOINING = new JoinReason("rejoining", null);

    public JoinReasonService(LongSupplier relativeTimeInMillisSupplier) {
        this.relativeTimeInMillisSupplier = relativeTimeInMillisSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public void onClusterStateApplied(DiscoveryNodes discoveryNodes) {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        assert (discoveryNodes.getLocalNode().isMasterNode());
        if (this.discoveryNodes != discoveryNodes) {
            this.discoveryNodes = discoveryNodes;
            HashSet<String> absentNodeIds = new HashSet<String>(this.trackedNodes.keySet());
            for (DiscoveryNode discoveryNode : discoveryNodes) {
                this.trackedNodes.compute(discoveryNode.getId(), (ignored, trackedNode) -> (trackedNode == null ? UNKNOWN_NODE : trackedNode).present(discoveryNode.getEphemeralId()));
                absentNodeIds.remove(discoveryNode.getId());
            }
            long currentTimeMillis = this.relativeTimeInMillisSupplier.getAsLong();
            for (String string : absentNodeIds) {
                this.trackedNodes.computeIfPresent(string, (ignored, trackedNode) -> trackedNode.absent(currentTimeMillis, discoveryNodes.getMasterNode()));
            }
            if (absentNodeIds.size() > 2 * discoveryNodes.getSize()) {
                void var6_10;
                ArrayList<Tuple> absentNodes = new ArrayList<Tuple>(absentNodeIds.size());
                for (Map.Entry<String, TrackedNode> entry : this.trackedNodes.entrySet()) {
                    long removalAgeMillis = entry.getValue().getRemovalAgeMillis(currentTimeMillis);
                    if (removalAgeMillis == -1L) continue;
                    absentNodes.add(Tuple.tuple((Object)removalAgeMillis, (Object)entry.getKey()));
                }
                absentNodes.sort(Comparator.comparing(Tuple::v1));
                int n = discoveryNodes.getSize();
                while (var6_10 < absentNodes.size()) {
                    this.trackedNodes.remove(((Tuple)absentNodes.get((int)var6_10)).v2());
                    ++var6_10;
                }
            }
            assert (this.trackedNodes.size() <= discoveryNodes.getSize() * 3);
        }
    }

    public void onNodeRemoved(DiscoveryNode discoveryNode, String reason) {
        assert (MasterService.assertMasterUpdateOrTestThread());
        this.trackedNodes.computeIfPresent(discoveryNode.getId(), (ignored, trackedNode) -> trackedNode.withRemovalReason(reason));
    }

    public JoinReason getJoinReason(DiscoveryNode discoveryNode, Coordinator.Mode currentMode) {
        return this.trackedNodes.getOrDefault(discoveryNode.getId(), UNKNOWN_NODE).getJoinReason(this.relativeTimeInMillisSupplier.getAsLong(), discoveryNode.getEphemeralId(), currentMode);
    }

    private static String getNodeNameSafe(@Nullable DiscoveryNode discoveryNode) {
        if (discoveryNode == null) {
            return "_unknown_";
        }
        String name = discoveryNode.getName();
        if (Strings.hasText(name)) {
            return name;
        }
        return discoveryNode.getId();
    }

    private static interface TrackedNode {
        public TrackedNode present(String var1);

        public TrackedNode absent(long var1, @Nullable DiscoveryNode var3);

        public TrackedNode withRemovalReason(String var1);

        public JoinReason getJoinReason(long var1, String var3, Coordinator.Mode var4);

        public long getRemovalAgeMillis(long var1);
    }

    private record AbsentNode(String ephemeralId, int removalCount, long removalTimeMillis, String removingNodeName, @Nullable String removalReason) implements TrackedNode
    {
        @Override
        public TrackedNode present(String ephemeralId) {
            return new PresentNode(ephemeralId, ephemeralId.equals(this.ephemeralId) ? this.removalCount : 0);
        }

        @Override
        public TrackedNode absent(long currentTimeMillis, DiscoveryNode masterNode) {
            return this;
        }

        @Override
        public TrackedNode withRemovalReason(String removalReason) {
            return new AbsentNode(this.ephemeralId, this.removalCount, this.removalTimeMillis, this.removingNodeName, removalReason);
        }

        @Override
        public JoinReason getJoinReason(long currentTimeMillis, String joiningNodeEphemeralId, Coordinator.Mode currentMode) {
            boolean isRestarted;
            StringBuilder description = new StringBuilder();
            if (currentMode == Coordinator.Mode.CANDIDATE) {
                description.append("completing election");
            } else {
                description.append("joining");
            }
            boolean bl = isRestarted = !joiningNodeEphemeralId.equals(this.ephemeralId);
            if (isRestarted) {
                description.append(" after restart");
            }
            description.append(", removed [");
            long removalAgeMillis = this.getRemovalAgeMillis(currentTimeMillis);
            if (removalAgeMillis >= 1000L) {
                description.append(TimeValue.timeValueMillis((long)removalAgeMillis)).append("/");
            }
            description.append(removalAgeMillis).append("ms] ago ");
            if (this.removalReason == null) {
                description.append("by [").append(this.removingNodeName).append("]");
            } else {
                description.append("with reason [").append(this.removalReason).append("]");
            }
            if (this.removalCount > 1 && !isRestarted) {
                description.append(", [").append(this.removalCount).append("] total removals");
            }
            return new JoinReason(description.toString(), isRestarted ? null : ReferenceDocs.UNSTABLE_CLUSTER_TROUBLESHOOTING);
        }

        @Override
        public long getRemovalAgeMillis(long currentTimeMillis) {
            return currentTimeMillis - this.removalTimeMillis;
        }
    }

    private record PresentNode(String ephemeralId, int removalCount) implements TrackedNode
    {
        @Override
        public TrackedNode present(String ephemeralId) {
            return ephemeralId.equals(this.ephemeralId) ? this : new PresentNode(ephemeralId, 0);
        }

        @Override
        public TrackedNode absent(long currentTimeMillis, DiscoveryNode masterNode) {
            return new AbsentNode(this.ephemeralId, this.removalCount + 1, currentTimeMillis, JoinReasonService.getNodeNameSafe(masterNode), null);
        }

        @Override
        public TrackedNode withRemovalReason(String removalReason) {
            return this;
        }

        @Override
        public JoinReason getJoinReason(long currentTimeMillis, String joiningNodeEphemeralId, Coordinator.Mode currentMode) {
            if (currentMode == Coordinator.Mode.CANDIDATE) {
                return COMPLETING_ELECTION;
            }
            return KNOWN_NODE_REJOINING;
        }

        @Override
        public long getRemovalAgeMillis(long currentTimeMillis) {
            return -1L;
        }
    }
}

