/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.synonyms.SynonymUpdateResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSynonymRuleAction
extends ActionType<SynonymUpdateResponse> {
    public static final DeleteSynonymRuleAction INSTANCE = new DeleteSynonymRuleAction();
    public static final String NAME = "cluster:admin/synonym_rules/delete";

    public DeleteSynonymRuleAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final String synonymsSetId;
        private final String synonymRuleId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
            this.synonymRuleId = in.readString();
        }

        public Request(String synonymsSetId, String synonymRuleId) {
            this.synonymsSetId = synonymsSetId;
            this.synonymRuleId = synonymRuleId;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty(this.synonymsSetId)) {
                validationException = ValidateActions.addValidationError("synonyms set must be specified", validationException);
            }
            if (Strings.isNullOrEmpty(this.synonymRuleId)) {
                validationException = ValidateActions.addValidationError("synonym rule id must be specified", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
            out.writeString(this.synonymRuleId);
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        public String synonymRuleId() {
            return this.synonymRuleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.synonymsSetId, request.synonymsSetId) && Objects.equals(this.synonymRuleId, request.synonymRuleId);
        }

        public int hashCode() {
            return Objects.hash(this.synonymsSetId, this.synonymRuleId);
        }
    }
}

