/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CancellableFanOut;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public abstract class TransportBroadcastByNodeAction<Request extends BroadcastRequest<Request>, Response extends BaseBroadcastResponse, ShardOperationResult extends Writeable, NodeContext>
extends HandledTransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportBroadcastByNodeAction.class);
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Executor executor;
    final String transportNodeBroadcastAction;
    private final Writeable.Reader<NodeResponse> nodeResponseReader = x$0 -> new NodeResponse(x$0);

    public TransportBroadcastByNodeAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, Executor executor) {
        this(actionName, clusterService, transportService, actionFilters, indexNameExpressionResolver, request, executor, true);
    }

    public TransportBroadcastByNodeAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, Executor executor, boolean canTripCircuitBreaker) {
        super(actionName, canTripCircuitBreaker, transportService, actionFilters, request, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = executor;
        assert (this.executor != EsExecutors.DIRECT_EXECUTOR_SERVICE) : "O(#shards) work must always fork to an appropriate executor";
        this.transportNodeBroadcastAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeBroadcastAction, this.executor, false, canTripCircuitBreaker, x$0 -> new NodeRequest(x$0), new BroadcastByNodeTransportRequestHandler());
    }

    protected abstract ShardOperationResult readShardResult(StreamInput var1) throws IOException;

    protected abstract ResponseFactory<Response, ShardOperationResult> getResponseFactory(Request var1, ClusterState var2);

    protected abstract Request readRequestFrom(StreamInput var1) throws IOException;

    protected abstract void shardOperation(Request var1, ShardRouting var2, Task var3, @Nullable NodeContext var4, ActionListener<ShardOperationResult> var5);

    @Nullable
    protected NodeContext createNodeContext() {
        return null;
    }

    protected abstract ShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    protected String[] resolveConcreteIndexNames(ClusterState clusterState, Request request) {
        return this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        request.mustIncRef();
        this.executor.execute(ActionRunnable.wrapReleasing(listener, () -> request.decRef(), l -> this.doExecuteForked(task, request, listener)));
    }

    private void doExecuteForked(Task task, Request request, ActionListener<Response> listener) {
        assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException globalBlockException = this.checkGlobalBlock(clusterState, request);
        if (globalBlockException != null) {
            throw globalBlockException;
        }
        String[] concreteIndices = this.resolveConcreteIndexNames(clusterState, request);
        ClusterBlockException requestBlockException = this.checkRequestBlock(clusterState, request, concreteIndices);
        if (requestBlockException != null) {
            throw requestBlockException;
        }
        logger.trace(() -> Strings.format((String)"resolving shards for [%s] based on cluster state version [%s]", (Object[])new Object[]{this.actionName, clusterState.version()}));
        ShardsIterator shardIt = this.shards(clusterState, request, concreteIndices);
        HashMap<String, List<ShardRouting>> shardsByNodeId = new HashMap<String, List<ShardRouting>>();
        DiscoveryNodes nodes = clusterState.nodes();
        int unavailableShardCount = 0;
        int availableShardCount = 0;
        for (ShardRouting shard : shardIt) {
            String nodeId = shard.currentNodeId();
            if (nodeId != null && nodes.get(nodeId) != null) {
                shardsByNodeId.computeIfAbsent(nodeId, n -> new ArrayList()).add(shard);
                ++availableShardCount;
                continue;
            }
            ++unavailableShardCount;
        }
        this.executeAsCoordinatingNode(task, request, shardsByNodeId, unavailableShardCount, availableShardCount, nodes, this.getResponseFactory(request, clusterState), listener);
    }

    private void executeAsCoordinatingNode(Task task, Request request, Map<String, List<ShardRouting>> shardsByNodeId, final int unavailableShardCount, final int availableShardCount, DiscoveryNodes nodes, ResponseFactory<Response, ShardOperationResult> responseFactory, ActionListener<Response> listener) {
        new CancellableFanOut<Map.Entry<String, List<ShardRouting>>, NodeResponse, Response>((BroadcastRequest)request, nodes, task, responseFactory){
            final ArrayList<ShardOperationResult> shardResponses;
            final ArrayList<DefaultShardOperationFailedException> exceptions;
            final AtomicInteger totalShards;
            final AtomicInteger successfulShards;
            final TransportRequestOptions transportRequestOptions;
            final /* synthetic */ BroadcastRequest val$request;
            final /* synthetic */ DiscoveryNodes val$nodes;
            final /* synthetic */ Task val$task;
            final /* synthetic */ ResponseFactory val$responseFactory;
            {
                this.val$request = broadcastRequest;
                this.val$nodes = discoveryNodes;
                this.val$task = task;
                this.val$responseFactory = responseFactory;
                this.shardResponses = new ArrayList(availableShardCount);
                this.exceptions = new ArrayList(0);
                this.totalShards = new AtomicInteger(unavailableShardCount);
                this.successfulShards = new AtomicInteger(0);
                this.transportRequestOptions = TransportRequestOptions.timeout(this.val$request.timeout());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void sendItemRequest(Map.Entry<String, List<ShardRouting>> entry, ActionListener<NodeResponse> listener) {
                DiscoveryNode node = this.val$nodes.get(entry.getKey());
                List<ShardRouting> shards = entry.getValue();
                NodeRequest nodeRequest = new NodeRequest(TransportBroadcastByNodeAction.this, this.val$request, shards, node.getId());
                if (this.val$task != null) {
                    nodeRequest.setParentTask(TransportBroadcastByNodeAction.this.clusterService.localNode().getId(), this.val$task.getId());
                }
                try {
                    TransportBroadcastByNodeAction.this.transportService.sendRequest(node, TransportBroadcastByNodeAction.this.transportNodeBroadcastAction, (TransportRequest)nodeRequest, this.transportRequestOptions, new ActionListenerResponseHandler<NodeResponse>(listener, TransportBroadcastByNodeAction.this.nodeResponseReader, TransportBroadcastByNodeAction.this.executor));
                }
                finally {
                    nodeRequest.decRef();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemResponse(Map.Entry<String, List<ShardRouting>> entry, NodeResponse nodeResponse) {
                assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
                DiscoveryNode node = this.val$nodes.get(entry.getKey());
                1 var4_4 = this;
                synchronized (var4_4) {
                    this.shardResponses.addAll(nodeResponse.getResults());
                }
                this.totalShards.addAndGet(nodeResponse.getTotalShards());
                this.successfulShards.addAndGet(nodeResponse.getSuccessfulShards());
                for (BroadcastShardOperationFailedException exception : nodeResponse.getExceptions()) {
                    if (TransportActions.isShardNotAvailableException(exception)) {
                        assert (node.getVersion().before(Version.V_8_7_0)) : node;
                        continue;
                    }
                    1 var6_7 = this;
                    synchronized (var6_7) {
                        this.exceptions.add(new DefaultShardOperationFailedException(exception.getShardId().getIndexName(), exception.getShardId().getId(), exception));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemFailure(Map.Entry<String, List<ShardRouting>> entry, Exception e) {
                assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
                DiscoveryNode node = this.val$nodes.get(entry.getKey());
                List<ShardRouting> shards = entry.getValue();
                logger.debug(() -> Strings.format((String)"failed to execute [%s] on node [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, node}), (Throwable)e);
                FailedNodeException failedNodeException = new FailedNodeException(node.getId(), "Failed node [" + node.getId() + "]", e);
                1 var6_6 = this;
                synchronized (var6_6) {
                    for (ShardRouting shard : shards) {
                        this.exceptions.add(new DefaultShardOperationFailedException(shard.getIndexName(), shard.getId(), failedNodeException));
                    }
                }
                this.totalShards.addAndGet(shards.size());
            }

            @Override
            protected Response onCompletion() {
                assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
                return (BaseBroadcastResponse)this.val$responseFactory.newResponse(this.totalShards.get(), this.successfulShards.get(), this.exceptions.size(), this.shardResponses, this.exceptions);
            }

            public String toString() {
                return TransportBroadcastByNodeAction.this.actionName;
            }
        }.run(task, shardsByNodeId.entrySet().iterator(), listener);
    }

    private void executeAsDataNode(Task task, Request request, final List<ShardRouting> shards, String nodeId, ActionListener<NodeResponse> listener) {
        assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
        logger.trace("[{}] executing operation on [{}] shards", (Object)this.actionName, (Object)shards.size());
        NodeContext nodeContext = this.createNodeContext();
        new CancellableFanOut<ShardRouting, ShardOperationResult, NodeResponse>((BroadcastRequest)request, task, nodeContext, nodeId){
            final ArrayList<ShardOperationResult> results;
            final ArrayList<BroadcastShardOperationFailedException> exceptions;
            final /* synthetic */ BroadcastRequest val$request;
            final /* synthetic */ Task val$task;
            final /* synthetic */ Object val$nodeContext;
            final /* synthetic */ String val$nodeId;
            {
                this.val$request = broadcastRequest;
                this.val$task = task;
                this.val$nodeContext = object;
                this.val$nodeId = string;
                this.results = new ArrayList(shards.size());
                this.exceptions = new ArrayList(0);
            }

            @Override
            protected void sendItemRequest(ShardRouting shardRouting, ActionListener<ShardOperationResult> listener) {
                logger.trace(() -> Strings.format((String)"[%s] executing operation for shard [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary()}));
                ActionRunnable.wrap(listener, l -> TransportBroadcastByNodeAction.this.shardOperation(this.val$request, shardRouting, this.val$task, this.val$nodeContext, l)).run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemResponse(ShardRouting shardRouting, ShardOperationResult shardOperationResult) {
                assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
                ArrayList arrayList = this.results;
                synchronized (arrayList) {
                    this.results.add(shardOperationResult);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemFailure(ShardRouting shardRouting, Exception e) {
                assert (Transports.assertNotTransportThread("O(#shards) work must always fork to an appropriate executor"));
                logger.log(TransportActions.isShardNotAvailableException(e) ? Level.TRACE : Level.DEBUG, () -> Strings.format((String)"[%s] failed to execute operation for shard [%s]", (Object[])new Object[]{TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary()}), (Throwable)e);
                if (!TransportActions.isShardNotAvailableException(e)) {
                    ArrayList<BroadcastShardOperationFailedException> arrayList = this.exceptions;
                    synchronized (arrayList) {
                        this.exceptions.add(new BroadcastShardOperationFailedException(shardRouting.shardId(), "operation " + TransportBroadcastByNodeAction.this.actionName + " failed", e));
                    }
                }
            }

            @Override
            protected NodeResponse onCompletion() {
                return new NodeResponse(this.val$nodeId, shards.size(), this.results, this.exceptions);
            }

            public String toString() {
                return TransportBroadcastByNodeAction.this.transportNodeBroadcastAction;
            }
        }.run(task, shards.iterator(), listener);
    }

    class BroadcastByNodeTransportRequestHandler
    implements TransportRequestHandler<NodeRequest> {
        BroadcastByNodeTransportRequestHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            TransportBroadcastByNodeAction.this.executeAsDataNode(task, request.getIndicesLevelRequest(), request.getShards(), request.getNodeId(), new ChannelActionListener<NodeResponse>(channel));
        }
    }

    public static interface ResponseFactory<Response, ShardOperationResult> {
        public Response newResponse(int var1, int var2, int var3, List<ShardOperationResult> var4, List<DefaultShardOperationFailedException> var5);
    }

    public class NodeResponse
    extends TransportResponse {
        protected String nodeId;
        protected int totalShards;
        protected List<BroadcastShardOperationFailedException> exceptions;
        protected List<ShardOperationResult> results;

        NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            this.totalShards = in.readVInt();
            this.results = in.readCollectionAsList(stream -> stream.readBoolean() ? (Writeable)TransportBroadcastByNodeAction.this.readShardResult(stream) : null);
            this.exceptions = in.readBoolean() ? in.readCollectionAsList(BroadcastShardOperationFailedException::new) : null;
        }

        public NodeResponse(String nodeId, int totalShards, List<ShardOperationResult> results, List<BroadcastShardOperationFailedException> exceptions) {
            this.nodeId = nodeId;
            this.totalShards = totalShards;
            this.results = results;
            this.exceptions = exceptions;
        }

        String getNodeId() {
            return this.nodeId;
        }

        int getTotalShards() {
            return this.totalShards;
        }

        int getSuccessfulShards() {
            return this.results.size();
        }

        List<ShardOperationResult> getResults() {
            return this.results;
        }

        List<BroadcastShardOperationFailedException> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeVInt(this.totalShards);
            out.writeCollection(this.results, StreamOutput::writeOptionalWriteable);
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                out.writeCollection(this.exceptions);
            }
        }
    }

    class NodeRequest
    extends TransportRequest
    implements IndicesRequest {
        private final Request indicesLevelRequest;
        private final List<ShardRouting> shards;
        private final String nodeId;

        NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.indicesLevelRequest = TransportBroadcastByNodeAction.this.readRequestFrom(in);
            this.shards = in.readCollectionAsList(ShardRouting::new);
            this.nodeId = in.readString();
        }

        NodeRequest(Request indicesLevelRequest, List<ShardRouting> shards, String nodeId) {
            indicesLevelRequest.mustIncRef();
            this.indicesLevelRequest = indicesLevelRequest;
            this.shards = shards;
            this.nodeId = nodeId;
        }

        List<ShardRouting> getShards() {
            return this.shards;
        }

        String getNodeId() {
            return this.nodeId;
        }

        Request getIndicesLevelRequest() {
            return this.indicesLevelRequest;
        }

        @Override
        public String[] indices() {
            return ((BroadcastRequest)this.indicesLevelRequest).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((BroadcastRequest)this.indicesLevelRequest).indicesOptions();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (((TransportMessage)this.indicesLevelRequest).hasReferences());
            super.writeTo(out);
            ((BroadcastRequest)this.indicesLevelRequest).writeTo(out);
            out.writeCollection(this.shards);
            out.writeString(this.nodeId);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return this.indicesLevelRequest.createTask(id, type, action, parentTaskId, headers);
        }

        @Override
        public void incRef() {
            ((TransportMessage)this.indicesLevelRequest).incRef();
        }

        @Override
        public boolean tryIncRef() {
            return ((TransportMessage)this.indicesLevelRequest).tryIncRef();
        }

        @Override
        public boolean decRef() {
            return ((TransportMessage)this.indicesLevelRequest).decRef();
        }

        @Override
        public boolean hasReferences() {
            return ((TransportMessage)this.indicesLevelRequest).hasReferences();
        }

        @Override
        public String toString() {
            return "[" + TransportBroadcastByNodeAction.this.transportNodeBroadcastAction + "][" + this.nodeId + "][" + String.valueOf(this.indicesLevelRequest) + "]";
        }
    }

    public static final class EmptyResult
    implements Writeable {
        public static EmptyResult INSTANCE = new EmptyResult();

        private EmptyResult() {
        }

        @Override
        public void writeTo(StreamOutput out) {
        }
    }
}

