/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMultiSearchAction
extends HandledTransportAction<MultiSearchRequest, MultiSearchResponse> {
    public static final String NAME = "indices:data/read/msearch";
    public static final ActionType<MultiSearchResponse> TYPE = new ActionType("indices:data/read/msearch");
    private static final Logger logger = LogManager.getLogger(TransportMultiSearchAction.class);
    private final int allocatedProcessors;
    private final ClusterService clusterService;
    private final LongSupplier relativeTimeProvider;
    private final NodeClient client;

    @Inject
    public TransportMultiSearchAction(Settings settings, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NodeClient client) {
        super(TYPE.name(), transportService, actionFilters, MultiSearchRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.allocatedProcessors = EsExecutors.allocatedProcessors(settings);
        this.relativeTimeProvider = System::nanoTime;
        this.client = client;
    }

    TransportMultiSearchAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, int allocatedProcessors, LongSupplier relativeTimeProvider, NodeClient client) {
        super(TYPE.name(), transportService, actionFilters, MultiSearchRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.allocatedProcessors = allocatedProcessors;
        this.relativeTimeProvider = relativeTimeProvider;
        this.client = client;
    }

    @Override
    protected void doExecute(Task task, MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        long relativeStartTime = this.relativeTimeProvider.getAsLong();
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        int maxConcurrentSearches = request.maxConcurrentSearchRequests();
        if (maxConcurrentSearches == 0) {
            maxConcurrentSearches = TransportMultiSearchAction.defaultMaxConcurrentSearches(this.allocatedProcessors, clusterState);
        }
        ConcurrentLinkedQueue<SearchRequestSlot> searchRequestSlots = new ConcurrentLinkedQueue<SearchRequestSlot>();
        for (int i = 0; i < request.requests().size(); ++i) {
            SearchRequest searchRequest = request.requests().get(i);
            searchRequest.setParentTask(this.client.getLocalNodeId(), task.getId());
            searchRequestSlots.add(new SearchRequestSlot(searchRequest, i));
        }
        int numRequests = request.requests().size();
        AtomicArray<MultiSearchResponse.Item> responses = new AtomicArray<MultiSearchResponse.Item>(numRequests);
        AtomicInteger responseCounter = new AtomicInteger(numRequests);
        int numConcurrentSearches = Math.min(numRequests, maxConcurrentSearches);
        for (int i = 0; i < numConcurrentSearches; ++i) {
            this.executeSearch(searchRequestSlots, responses, responseCounter, listener, relativeStartTime);
        }
    }

    static int defaultMaxConcurrentSearches(int allocatedProcessors, ClusterState state) {
        int numDateNodes = state.getNodes().getDataNodes().size();
        int defaultSearchThreadPoolSize = Math.min(ThreadPool.searchOrGetThreadPoolSize(allocatedProcessors), 10);
        return Math.max(1, numDateNodes * defaultSearchThreadPoolSize);
    }

    void executeSearch(Queue<SearchRequestSlot> requests, AtomicArray<MultiSearchResponse.Item> responses, AtomicInteger responseCounter, ActionListener<MultiSearchResponse> listener, long relativeStartTime) {
        SearchRequestSlot request = requests.poll();
        while (request != null && this.doExecuteSearch(requests, responses, responseCounter, relativeStartTime, request, listener)) {
            request = requests.poll();
        }
    }

    private boolean doExecuteSearch(final Queue<SearchRequestSlot> requests, final AtomicArray<MultiSearchResponse.Item> responses, final AtomicInteger responseCounter, final long relativeStartTime, final SearchRequestSlot request, final ActionListener<MultiSearchResponse> listener) {
        SubscribableListener<ChunkedToXContent> subscribeListener = new SubscribableListener<ChunkedToXContent>();
        this.client.search(request.request, subscribeListener.safeMap(searchResponse -> {
            searchResponse.mustIncRef();
            return new MultiSearchResponse.Item((SearchResponse)searchResponse, null);
        }));
        ActionListener<MultiSearchResponse.Item> responseListener = new ActionListener<MultiSearchResponse.Item>(){

            @Override
            public void onResponse(MultiSearchResponse.Item searchResponse) {
                this.handleResponse(request.responseSlot, searchResponse);
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.status(e).getStatus() >= 500 && !ExceptionsHelper.isNodeOrShardUnavailableTypeException(e)) {
                    logger.warn("TransportMultiSearchAction failure", (Throwable)e);
                }
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(null, e));
            }

            private void handleResponse(int responseSlot, MultiSearchResponse.Item item) {
                responses.set(responseSlot, item);
                if (responseCounter.decrementAndGet() == 0) {
                    assert (requests.isEmpty());
                    this.finish();
                }
            }

            private void finish() {
                ActionListener.respondAndRelease(listener, new MultiSearchResponse(responses.toArray(new MultiSearchResponse.Item[responses.length()]), this.buildTookInMillis()));
            }

            private long buildTookInMillis() {
                return TimeUnit.NANOSECONDS.toMillis(TransportMultiSearchAction.this.relativeTimeProvider.getAsLong() - relativeStartTime);
            }
        };
        if (subscribeListener.isDone()) {
            subscribeListener.addListener(responseListener);
            return true;
        }
        subscribeListener.addListener(ActionListener.runAfter(responseListener, () -> this.executeSearch(requests, responses, responseCounter, listener, relativeStartTime)));
        return false;
    }

    record SearchRequestSlot(SearchRequest request, int responseSlot) {
    }
}

