/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.rollover.LazyRolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.FailureStoreDocumentConverter;
import org.elasticsearch.action.bulk.FailureStoreMetrics;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreSettings;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;

final class BulkOperation
extends ActionRunnable<BulkResponse> {
    private static final Logger logger = LogManager.getLogger(BulkOperation.class);
    private final Task task;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private BulkRequest bulkRequest;
    private final ActionListener<BulkResponse> listener;
    private final AtomicArray<BulkItemResponse> responses;
    private final ConcurrentLinkedQueue<BulkItemRequest> failureStoreRedirects = new ConcurrentLinkedQueue();
    private final long startTimeNanos;
    private final ClusterStateObserver observer;
    private final Executor executor;
    private final LongSupplier relativeTimeProvider;
    private final FailureStoreDocumentConverter failureStoreDocumentConverter;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NodeClient client;
    private final OriginSettingClient rolloverClient;
    private final Set<String> failureStoresToBeRolledOver = ConcurrentCollections.newConcurrentSet();
    private final Set<Integer> failedRolloverRequests = ConcurrentCollections.newConcurrentSet();
    private final Map<ShardId, Exception> shortCircuitShardFailures = ConcurrentCollections.newConcurrentMap();
    private final FailureStoreMetrics failureStoreMetrics;
    private final DataStreamFailureStoreSettings dataStreamFailureStoreSettings;
    private final boolean clusterHasFailureStoreFeature;

    BulkOperation(Task task, ThreadPool threadPool, Executor executor, ClusterService clusterService, BulkRequest bulkRequest, NodeClient client, AtomicArray<BulkItemResponse> responses, IndexNameExpressionResolver indexNameExpressionResolver, LongSupplier relativeTimeProvider, long startTimeNanos, ActionListener<BulkResponse> listener, FailureStoreMetrics failureStoreMetrics, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, boolean clusterHasFailureStoreFeature) {
        this(task, threadPool, executor, clusterService, bulkRequest, client, responses, indexNameExpressionResolver, relativeTimeProvider, startTimeNanos, listener, new ClusterStateObserver(clusterService, bulkRequest.timeout(), logger, threadPool.getThreadContext()), new FailureStoreDocumentConverter(), failureStoreMetrics, dataStreamFailureStoreSettings, clusterHasFailureStoreFeature);
    }

    BulkOperation(Task task, ThreadPool threadPool, Executor executor, ClusterService clusterService, BulkRequest bulkRequest, NodeClient client, AtomicArray<BulkItemResponse> responses, IndexNameExpressionResolver indexNameExpressionResolver, LongSupplier relativeTimeProvider, long startTimeNanos, ActionListener<BulkResponse> listener, ClusterStateObserver observer, FailureStoreDocumentConverter failureStoreDocumentConverter, FailureStoreMetrics failureStoreMetrics, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, boolean clusterHasFailureStoreFeature) {
        super(listener);
        this.task = task;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.responses = responses;
        this.bulkRequest = bulkRequest;
        this.listener = listener;
        this.startTimeNanos = startTimeNanos;
        this.executor = executor;
        this.relativeTimeProvider = relativeTimeProvider;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
        this.observer = observer;
        this.failureStoreDocumentConverter = failureStoreDocumentConverter;
        this.rolloverClient = new OriginSettingClient(client, "lazy_rollover");
        this.shortCircuitShardFailures.putAll(bulkRequest.incrementalState().shardLevelFailures());
        this.failureStoreMetrics = failureStoreMetrics;
        this.dataStreamFailureStoreSettings = dataStreamFailureStoreSettings;
        this.clusterHasFailureStoreFeature = clusterHasFailureStoreFeature;
    }

    @Override
    protected void doRun() {
        assert (this.bulkRequest != null);
        ClusterState clusterState = this.observer.setAndGetObservedState();
        if (this.handleBlockExceptions(clusterState, this, this::onFailure)) {
            return;
        }
        Map<ShardId, List<BulkItemRequest>> requestsByShard = this.groupBulkRequestsByShards(clusterState);
        this.executeBulkRequestsByShard(requestsByShard, clusterState, this::redirectFailuresOrCompleteBulkOperation);
    }

    private void doRedirectFailures() {
        assert (!this.failureStoreRedirects.isEmpty()) : "Attempting to redirect failures, but none were present in the queue";
        ClusterState clusterState = this.observer.setAndGetObservedState();
        if (this.handleBlockExceptions(clusterState, ActionRunnable.wrap(this.listener, l -> this.doRedirectFailures()), this::discardRedirectsAndFinish)) {
            return;
        }
        Runnable executeRedirectRequests = () -> {
            ClusterState rolledOverState = this.observer.setAndGetObservedState();
            Map<ShardId, List<BulkItemRequest>> requestsByShard = this.drainAndGroupRedirectsByShards(rolledOverState);
            this.executeBulkRequestsByShard(requestsByShard, rolledOverState, this::completeBulkOperation);
        };
        this.rollOverFailureStores(executeRedirectRequests);
    }

    private void rollOverFailureStores(Runnable runnable) {
        if (this.failureStoresToBeRolledOver.isEmpty()) {
            runnable.run();
            return;
        }
        try (RefCountingRunnable refs = new RefCountingRunnable(runnable);){
            for (final String dataStream : this.failureStoresToBeRolledOver) {
                RolloverRequest rolloverRequest = new RolloverRequest(IndexNameExpressionResolver.combineSelector(dataStream, IndexComponentSelector.FAILURES), null);
                this.rolloverClient.execute(LazyRolloverAction.INSTANCE, rolloverRequest, ActionListener.releaseAfter(new ActionListener<RolloverResponse>(){

                    @Override
                    public void onResponse(RolloverResponse result) {
                        logger.debug("Data stream failure store {} has {} over, the latest index is {}", (Object)dataStream, (Object)(result.isRolledOver() ? "been successfully rolled" : "skipped rolling"), (Object)result.getNewIndex());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        for (BulkItemRequest failureStoreRedirect : BulkOperation.this.failureStoreRedirects) {
                            if (!failureStoreRedirect.index().equals(dataStream)) continue;
                            BulkOperation.this.addFailure(failureStoreRedirect.request(), failureStoreRedirect.id(), failureStoreRedirect.index(), e, IndexDocFailureStoreStatus.FAILED);
                            BulkOperation.this.failedRolloverRequests.add(failureStoreRedirect.id());
                        }
                    }
                }, refs.acquire()));
            }
        }
    }

    private long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeNanos);
    }

    private Map<ShardId, List<BulkItemRequest>> groupBulkRequestsByShards(ClusterState clusterState) {
        return this.groupRequestsByShards(clusterState, Iterators.enumerate(this.bulkRequest.requests.iterator(), BulkItemRequest::new), BulkOperation::validateWriteIndex);
    }

    private Map<ShardId, List<BulkItemRequest>> drainAndGroupRedirectsByShards(ClusterState clusterState) {
        return this.groupRequestsByShards(clusterState, Iterators.fromSupplier(this.failureStoreRedirects::poll), (ia, ignore) -> BulkOperation.validateRedirectIndex(ia));
    }

    private Map<ShardId, List<BulkItemRequest>> groupRequestsByShards(ClusterState clusterState, Iterator<BulkItemRequest> it, BiConsumer<IndexAbstraction, DocWriteRequest<?>> indexOperationValidator) {
        ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, this.indexNameExpressionResolver);
        Metadata metadata = clusterState.metadata();
        HashMap<ShardId, List<BulkItemRequest>> requestsByShard = new HashMap<ShardId, List<BulkItemRequest>>();
        while (it.hasNext()) {
            BulkItemRequest bulkItemRequest = it.next();
            DocWriteRequest<?> docWriteRequest = bulkItemRequest.request();
            if (docWriteRequest == null || this.addFailureIfRequiresAliasAndAliasIsMissing(docWriteRequest, bulkItemRequest.id(), metadata) || this.addFailureIfRequiresDataStreamAndNoParentDataStream(docWriteRequest, bulkItemRequest.id(), metadata) || this.failedRolloverRequests.contains(bulkItemRequest.id())) continue;
            IndexAbstraction ia = null;
            try {
                ia = concreteIndices.resolveIfAbsent(docWriteRequest);
                indexOperationValidator.accept(ia, docWriteRequest);
                TransportBulkAction.prohibitCustomRoutingOnDataStream(docWriteRequest, ia);
                TransportBulkAction.prohibitAppendWritesInBackingIndices(docWriteRequest, ia);
                docWriteRequest.routing(metadata.resolveWriteIndexRouting(docWriteRequest.routing(), docWriteRequest.index()));
                Index concreteIndex = docWriteRequest.getConcreteWriteIndex(ia, metadata);
                if (this.addFailureIfIndexIsClosed(docWriteRequest, concreteIndex, bulkItemRequest.id(), metadata)) continue;
                IndexRouting indexRouting = concreteIndices.routing(concreteIndex);
                docWriteRequest.preRoutingProcess(indexRouting);
                int shardId = docWriteRequest.route(indexRouting);
                docWriteRequest.postRoutingProcess(indexRouting);
                List shardRequests = requestsByShard.computeIfAbsent(new ShardId(concreteIndex, shardId), shard -> new ArrayList());
                shardRequests.add(bulkItemRequest);
            }
            catch (DataStream.TimestampError timestampError) {
                IndexDocFailureStoreStatus failureStoreStatus = this.processFailure(bulkItemRequest, clusterState, timestampError);
                if (IndexDocFailureStoreStatus.USED.equals(failureStoreStatus)) continue;
                String name = ia != null ? ia.getName() : docWriteRequest.index();
                this.addFailureAndDiscardRequest(docWriteRequest, bulkItemRequest.id(), name, timestampError, failureStoreStatus);
            }
            catch (IllegalArgumentException | ElasticsearchParseException | ResourceNotFoundException | RoutingMissingException e) {
                String name = ia != null ? ia.getName() : docWriteRequest.index();
                IndexDocFailureStoreStatus failureStoreStatus = BulkOperation.isFailureStoreRequest(docWriteRequest) ? IndexDocFailureStoreStatus.FAILED : IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
                this.addFailureAndDiscardRequest(docWriteRequest, bulkItemRequest.id(), name, e, failureStoreStatus);
            }
        }
        return requestsByShard;
    }

    private static void validateWriteIndex(IndexAbstraction ia, DocWriteRequest<?> docWriteRequest) {
        boolean includeDataStreams;
        boolean bl = includeDataStreams = docWriteRequest.opType() == DocWriteRequest.OpType.CREATE;
        if (ia.isDataStreamRelated() && !includeDataStreams) {
            throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
        }
        if (ia.getParentDataStream() != null && !ia.getName().equals(docWriteRequest.index()) && docWriteRequest.opType() != DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
        }
    }

    private static void validateRedirectIndex(IndexAbstraction ia) {
        if (!ia.isDataStreamRelated()) {
            throw new IllegalArgumentException("only write ops to data streams with enabled failure stores can be redirected on failure.");
        }
    }

    private void executeBulkRequestsByShard(Map<ShardId, List<BulkItemRequest>> requestsByShard, ClusterState clusterState, Runnable onRequestsCompleted) {
        if (requestsByShard.isEmpty()) {
            onRequestsCompleted.run();
            return;
        }
        String nodeId = this.clusterService.localNode().getId();
        try (RefCountingRunnable bulkItemRequestCompleteRefCount = new RefCountingRunnable(onRequestsCompleted);){
            for (Map.Entry<ShardId, List<BulkItemRequest>> entry : requestsByShard.entrySet()) {
                ShardId shardId = entry.getKey();
                List<BulkItemRequest> requests = entry.getValue();
                BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, this.bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[0]), this.bulkRequest.isSimulated());
                IndexMetadata indexMetadata = clusterState.getMetadata().index(shardId.getIndexName());
                if (indexMetadata != null && !indexMetadata.getInferenceFields().isEmpty()) {
                    bulkShardRequest.setInferenceFieldMap(indexMetadata.getInferenceFields());
                }
                bulkShardRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
                bulkShardRequest.timeout(this.bulkRequest.timeout());
                bulkShardRequest.routedBasedOnClusterVersion(clusterState.version());
                if (this.task != null) {
                    bulkShardRequest.setParentTask(nodeId, this.task.getId());
                }
                this.executeBulkShardRequest(bulkShardRequest, bulkItemRequestCompleteRefCount.acquire());
            }
        }
    }

    private void redirectFailuresOrCompleteBulkOperation() {
        if (!this.failureStoreRedirects.isEmpty()) {
            this.doRedirectFailures();
        } else {
            this.completeBulkOperation();
        }
    }

    private void completeBulkOperation() {
        this.listener.onResponse(new BulkResponse(this.responses.toArray((BulkItemResponse[])new BulkItemResponse[this.responses.length()]), this.buildTookInMillis(this.startTimeNanos), -1L, new BulkRequest.IncrementalState(this.shortCircuitShardFailures, this.bulkRequest.incrementalState().indexingPressureAccounted())));
        this.bulkRequest = null;
    }

    private void discardRedirectsAndFinish(Exception exception) {
        assert (!this.failureStoreRedirects.isEmpty()) : "Attempting to discard redirects, but there were none to discard";
        Iterator<BulkItemRequest> redirectedBulkItemIterator = Iterators.fromSupplier(this.failureStoreRedirects::poll);
        while (redirectedBulkItemIterator.hasNext()) {
            BulkItemRequest cancelledRedirectBulkItem = redirectedBulkItemIterator.next();
            int slot = cancelledRedirectBulkItem.id();
            BulkItemResponse originalFailure = this.responses.get(slot);
            if (originalFailure.isFailed()) {
                originalFailure.getFailure().getCause().addSuppressed(exception);
                originalFailure.getFailure().setFailureStoreStatus(IndexDocFailureStoreStatus.FAILED);
            }
            this.responses.set(slot, originalFailure);
        }
        this.completeBulkOperation();
    }

    private void executeBulkShardRequest(final BulkShardRequest bulkShardRequest, final Releasable releaseOnFinish) {
        final ShardId shardId = bulkShardRequest.shardId();
        if (this.shortCircuitShardFailures.containsKey(shardId)) {
            this.handleShardFailure(bulkShardRequest, this.clusterService.state(), this.shortCircuitShardFailures.get(shardId));
            releaseOnFinish.close();
        } else {
            this.client.executeLocally(TransportShardBulkAction.TYPE, bulkShardRequest, new ActionListener<BulkShardResponse>(){
                private ClusterState clusterState = null;

                private ClusterState getClusterState() {
                    if (this.clusterState == null) {
                        this.clusterState = BulkOperation.this.clusterService.state();
                    }
                    return this.clusterState;
                }

                @Override
                public void onResponse(BulkShardResponse bulkShardResponse) {
                    for (int idx = 0; idx < bulkShardResponse.getResponses().length; ++idx) {
                        Object t;
                        BulkItemResponse bulkItemResponse = bulkShardResponse.getResponses()[idx];
                        BulkItemRequest bulkItemRequest = bulkShardRequest.items()[idx];
                        if (bulkItemResponse.isFailed()) {
                            assert (bulkItemRequest.id() == bulkItemResponse.getItemId()) : "Bulk items were returned out of order";
                            IndexDocFailureStoreStatus failureStoreStatus = BulkOperation.this.processFailure(bulkItemRequest, this.getClusterState(), bulkItemResponse.getFailure().getCause());
                            bulkItemResponse.getFailure().setFailureStoreStatus(failureStoreStatus);
                            BulkOperation.this.addFailure(bulkItemResponse);
                            continue;
                        }
                        ((ReplicationResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                        if (BulkOperation.isFailureStoreRequest(bulkItemRequest.request()) && (t = bulkItemResponse.getResponse()) instanceof IndexResponse) {
                            IndexResponse ir = (IndexResponse)t;
                            ir.setFailureStoreStatus(IndexDocFailureStoreStatus.USED);
                        }
                        BulkOperation.this.responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                    }
                    this.completeShardOperation();
                }

                @Override
                public void onFailure(Exception e) {
                    assert (!BulkOperation.this.shortCircuitShardFailures.containsKey(shardId));
                    BulkOperation.this.shortCircuitShardFailures.put(shardId, e);
                    BulkOperation.this.handleShardFailure(bulkShardRequest, this.getClusterState(), e);
                    this.completeShardOperation();
                }

                private void completeShardOperation() {
                    this.clusterState = null;
                    releaseOnFinish.close();
                }
            });
        }
    }

    private void handleShardFailure(BulkShardRequest bulkShardRequest, ClusterState clusterState, Exception e) {
        for (BulkItemRequest request : bulkShardRequest.items()) {
            String indexName = request.index();
            DocWriteRequest<?> docWriteRequest = request.request();
            IndexDocFailureStoreStatus failureStoreStatus = this.processFailure(request, clusterState, e);
            this.addFailure(docWriteRequest, request.id(), indexName, e, failureStoreStatus);
        }
    }

    private IndexDocFailureStoreStatus processFailure(BulkItemRequest bulkItemRequest, ClusterState clusterState, Exception cause) {
        Throwable error = ExceptionsHelper.unwrapCause(cause);
        String errorType = ElasticsearchException.getExceptionName(error);
        DocWriteRequest<?> docWriteRequest = bulkItemRequest.request();
        DataStream failureStoreCandidate = BulkOperation.getRedirectTargetCandidate(docWriteRequest, clusterState.metadata());
        if (failureStoreCandidate != null && this.clusterHasFailureStoreFeature) {
            boolean isFailureStoreRequest = BulkOperation.isFailureStoreRequest(docWriteRequest);
            if (!isFailureStoreRequest && failureStoreCandidate.isFailureStoreEffectivelyEnabled(this.dataStreamFailureStoreSettings) && !(error instanceof VersionConflictEngineException)) {
                this.maybeMarkFailureStoreForRollover(failureStoreCandidate);
                boolean added = this.addDocumentToRedirectRequests(bulkItemRequest, cause, failureStoreCandidate.getName());
                if (added) {
                    this.failureStoreMetrics.incrementFailureStore(bulkItemRequest.index(), errorType, FailureStoreMetrics.ErrorLocation.SHARD);
                    return IndexDocFailureStoreStatus.USED;
                }
                this.failureStoreMetrics.incrementRejected(bulkItemRequest.index(), errorType, FailureStoreMetrics.ErrorLocation.SHARD, isFailureStoreRequest);
                return IndexDocFailureStoreStatus.FAILED;
            }
            this.failureStoreMetrics.incrementRejected(bulkItemRequest.index(), errorType, FailureStoreMetrics.ErrorLocation.SHARD, isFailureStoreRequest);
            if (isFailureStoreRequest) {
                return IndexDocFailureStoreStatus.FAILED;
            }
            if (!failureStoreCandidate.isFailureStoreEffectivelyEnabled(this.dataStreamFailureStoreSettings)) {
                return IndexDocFailureStoreStatus.NOT_ENABLED;
            }
        }
        return IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
    }

    private static DataStream getRedirectTargetCandidate(DocWriteRequest<?> docWriteRequest, Metadata metadata) {
        IndexAbstraction ia = (IndexAbstraction)metadata.getIndicesLookup().get(docWriteRequest.index());
        return DataStream.resolveDataStream(ia, metadata);
    }

    private boolean addDocumentToRedirectRequests(BulkItemRequest request, Exception cause, String failureStoreReference) {
        IndexRequest failureStoreRequest;
        try {
            failureStoreRequest = this.failureStoreDocumentConverter.transformFailedRequest(TransportBulkAction.getIndexWriteRequest(request.request()), cause, failureStoreReference, this.threadPool::absoluteTimeInMillis);
        }
        catch (Exception exception) {
            logger.debug(() -> "Could not transform failed bulk request item into failure store document. Attempted for [" + String.valueOf((Object)request.request().opType()) + ": index=" + request.index() + "; id=" + request.request().id() + "; bulk_slot=" + request.id() + "] Proceeding with failing the original.", (Throwable)exception);
            cause.addSuppressed(exception);
            return false;
        }
        BulkItemRequest redirected = new BulkItemRequest(request.id(), failureStoreRequest);
        return this.failureStoreRedirects.add(redirected);
    }

    private void maybeMarkFailureStoreForRollover(DataStream dataStream) {
        if (!dataStream.getFailureComponent().isRolloverOnWrite()) {
            return;
        }
        this.failureStoresToBeRolledOver.add(dataStream.getName());
    }

    private boolean handleBlockExceptions(ClusterState state, Runnable retryOperation, Consumer<Exception> onClusterBlocked) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
        if (blockException != null) {
            if (blockException.retryable()) {
                logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                this.retry(blockException, retryOperation, onClusterBlocked);
            } else {
                onClusterBlocked.accept(blockException);
            }
            return true;
        }
        return false;
    }

    void retry(Exception failure, final Runnable operation, Consumer<Exception> onClusterBlocked) {
        assert (failure != null);
        if (this.observer.isTimedOut()) {
            onClusterBlocked.accept(failure);
            return;
        }
        this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                this.dispatchRetry();
            }

            @Override
            public void onClusterServiceClose() {
                BulkOperation.this.onFailure(new NodeClosedException(BulkOperation.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                this.dispatchRetry();
            }

            private void dispatchRetry() {
                BulkOperation.this.executor.execute(operation);
            }
        });
    }

    private boolean addFailureIfRequiresAliasAndAliasIsMissing(DocWriteRequest<?> request, int idx, Metadata metadata) {
        if (request.isRequireAlias() && !metadata.hasAlias(request.index())) {
            IndexNotFoundException exception = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
            this.addFailureAndDiscardRequest(request, idx, request.index(), exception, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
            return true;
        }
        return false;
    }

    private boolean addFailureIfRequiresDataStreamAndNoParentDataStream(DocWriteRequest<?> request, int idx, Metadata metadata) {
        if (request.isRequireDataStream() && !metadata.indexIsADataStream(request.index())) {
            ResourceNotFoundException exception = new ResourceNotFoundException("[require_data_stream] request flag is [true] and [" + request.index() + "] is not a data stream", request.index());
            this.addFailureAndDiscardRequest(request, idx, request.index(), exception, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
            return true;
        }
        return false;
    }

    private boolean addFailureIfIndexIsClosed(DocWriteRequest<?> request, Index concreteIndex, int idx, Metadata metadata) {
        IndexMetadata indexMetadata = metadata.getIndexSafe(concreteIndex);
        if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            IndexDocFailureStoreStatus failureStoreStatus = BulkOperation.isFailureStoreRequest(request) ? IndexDocFailureStoreStatus.FAILED : IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
            this.addFailureAndDiscardRequest(request, idx, request.index(), new IndexClosedException(concreteIndex), failureStoreStatus);
            return true;
        }
        return false;
    }

    private static boolean isFailureStoreRequest(DocWriteRequest<?> request) {
        IndexRequest ir;
        return request instanceof IndexRequest && (ir = (IndexRequest)request).isWriteToFailureStore();
    }

    private void addFailureAndDiscardRequest(DocWriteRequest<?> request, int idx, String index, Exception exception, IndexDocFailureStoreStatus failureStoreStatus) {
        this.addFailure(request, idx, index, exception, failureStoreStatus);
        this.bulkRequest.requests.set(idx, null);
    }

    private void addFailure(DocWriteRequest<?> request, int idx, String index, Exception exception, IndexDocFailureStoreStatus failureStoreStatus) {
        BulkItemResponse bulkItemResponse = this.responses.get(idx);
        if (bulkItemResponse == null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(index, request.id(), exception, failureStoreStatus);
            bulkItemResponse = BulkItemResponse.failure(idx, request.opType(), failure);
        } else {
            assert (bulkItemResponse.isFailed()) : "Attempting to overwrite successful bulk item result with a failure";
            bulkItemResponse.getFailure().getCause().addSuppressed(exception);
            bulkItemResponse.getFailure().setFailureStoreStatus(failureStoreStatus);
        }
        this.responses.set(idx, bulkItemResponse);
    }

    private void addFailure(BulkItemResponse bulkItemResponse) {
        assert (bulkItemResponse.isFailed()) : "Attempting to add a successful bulk item response via the addFailure method";
        BulkItemResponse existingBulkItemResponse = this.responses.get(bulkItemResponse.getItemId());
        if (existingBulkItemResponse != null) {
            assert (existingBulkItemResponse.isFailed()) : "Attempting to overwrite successful bulk item result with a failure";
            existingBulkItemResponse.getFailure().getCause().addSuppressed(bulkItemResponse.getFailure().getCause());
            existingBulkItemResponse.getFailure().setFailureStoreStatus(bulkItemResponse.getFailure().getFailureStoreStatus());
            bulkItemResponse = existingBulkItemResponse;
        }
        this.responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, IndexAbstraction> indexAbstractions = new HashMap<String, IndexAbstraction>();
        private final Map<Index, IndexRouting> routings = new HashMap<Index, IndexRouting>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        IndexAbstraction resolveIfAbsent(DocWriteRequest<?> request) {
            try {
                IndexAbstraction indexAbstraction = this.indexAbstractions.get(request.index());
                if (indexAbstraction == null) {
                    indexAbstraction = this.indexNameExpressionResolver.resolveWriteIndexAbstraction(this.state, request);
                    this.indexAbstractions.put(request.index(), indexAbstraction);
                }
                return indexAbstraction;
            }
            catch (IndexNotFoundException e) {
                if (e.getMetadataKeys().contains("es.excluded_ds")) {
                    throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams", e);
                }
                throw e;
            }
        }

        IndexRouting routing(Index index) {
            IndexRouting routing = this.routings.get(index);
            if (routing == null) {
                routing = IndexRouting.fromIndexMetadata(this.state.metadata().getIndexSafe(index));
                this.routings.put(index, routing);
            }
            return routing;
        }
    }
}

