/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.FieldStats;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class DenseVectorFieldStats
extends FieldStats {
    static final int UNSET = -1;
    static final String NOT_INDEXED = "not_indexed";
    Map<String, Integer> vectorIndexTypeCount = new HashMap<String, Integer>();
    Map<String, Integer> vectorSimilarityTypeCount = new HashMap<String, Integer>();
    Map<String, Integer> vectorElementTypeCount = new HashMap<String, Integer>();
    int indexedVectorCount = 0;
    int indexedVectorDimMin = -1;
    int indexedVectorDimMax = -1;

    DenseVectorFieldStats(String name) {
        super(name);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (false) : "writeTo should not be called on DenseVectorFieldStats";
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("indexed_vector_count", this.indexedVectorCount);
        builder.field("indexed_vector_dim_min", this.indexedVectorDimMin);
        builder.field("indexed_vector_dim_max", this.indexedVectorDimMax);
        if (!this.vectorIndexTypeCount.isEmpty()) {
            builder.startObject("vector_index_type_count");
            builder.mapContents(this.vectorIndexTypeCount);
            builder.endObject();
        }
        if (!this.vectorSimilarityTypeCount.isEmpty()) {
            builder.startObject("vector_similarity_type_count");
            builder.mapContents(this.vectorSimilarityTypeCount);
            builder.endObject();
        }
        if (!this.vectorElementTypeCount.isEmpty()) {
            builder.startObject("vector_element_type_count");
            builder.mapContents(this.vectorElementTypeCount);
            builder.endObject();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DenseVectorFieldStats that = (DenseVectorFieldStats)o;
        return this.indexedVectorCount == that.indexedVectorCount && this.indexedVectorDimMin == that.indexedVectorDimMin && this.indexedVectorDimMax == that.indexedVectorDimMax && Objects.equals(this.vectorIndexTypeCount, that.vectorIndexTypeCount) && Objects.equals(this.vectorSimilarityTypeCount, that.vectorSimilarityTypeCount) && Objects.equals(this.vectorElementTypeCount, that.vectorElementTypeCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexedVectorCount, this.indexedVectorDimMin, this.indexedVectorDimMax, this.vectorIndexTypeCount, this.vectorSimilarityTypeCount, this.vectorElementTypeCount);
    }

    @Override
    public String toString() {
        return "DenseVectorFieldStats{vectorIndexTypeCount=" + String.valueOf(this.vectorIndexTypeCount) + ", vectorSimilarityTypeCount=" + String.valueOf(this.vectorSimilarityTypeCount) + ", vectorElementTypeCount=" + String.valueOf(this.vectorElementTypeCount) + ", indexedVectorCount=" + this.indexedVectorCount + ", indexedVectorDimMin=" + this.indexedVectorDimMin + ", indexedVectorDimMax=" + this.indexedVectorDimMax + ", scriptCount=" + this.scriptCount + ", scriptLangs=" + String.valueOf(this.scriptLangs) + ", fieldScriptStats=" + String.valueOf(this.fieldScriptStats) + ", name='" + this.name + "', count=" + this.count + ", indexCount=" + this.indexCount + "}";
    }
}

