/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.capabilities;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodeCapability;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class NodesCapabilitiesResponse
extends BaseNodesResponse<NodeCapability>
implements ToXContentFragment {
    protected NodesCapabilitiesResponse(ClusterName clusterName, List<NodeCapability> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeCapability> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeCapability> nodes) throws IOException {
        TransportAction.localOnly();
    }

    public Optional<Boolean> isSupported() {
        if (this.hasFailures() || this.getNodes().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getNodes().stream().allMatch(NodeCapability::isSupported));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Optional<Boolean> supported = this.isSupported();
        return builder.field("supported", (Boolean)supported.orElse(null));
    }
}

