/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.core.termsenum.action.MultiShardTermsEnum;
import org.elasticsearch.xpack.core.termsenum.action.NodeTermsEnumRequest;
import org.elasticsearch.xpack.core.termsenum.action.NodeTermsEnumResponse;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumRequest;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumResponse;

public class TransportTermsEnumAction
extends HandledTransportAction<TermsEnumRequest, TermsEnumResponse> {
    private static final Logger logger = LogManager.getLogger(TransportTermsEnumAction.class);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchService searchService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    final String transportShardAction;
    private final Executor coordinationExecutor;
    private final Executor shardExecutor;
    private final XPackLicenseState licenseState;
    private final Settings settings;
    private final boolean ccsCheckCompatibility;

    @Inject
    public TransportTermsEnumAction(ClusterService clusterService, SearchService searchService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, ActionFilters actionFilters, XPackLicenseState licenseState, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/xpack/termsenum/list", transportService, actionFilters, TermsEnumRequest::new, (Executor)clusterService.threadPool().executor("search_coordination"));
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = this.actionName + "[s]";
        this.coordinationExecutor = clusterService.threadPool().executor("search_coordination");
        this.shardExecutor = clusterService.threadPool().executor("auto_complete");
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.licenseState = licenseState;
        this.settings = settings;
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.ccsCheckCompatibility = (Boolean)SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        transportService.registerRequestHandler(this.transportShardAction, this.coordinationExecutor, NodeTermsEnumRequest::new, (TransportRequestHandler)new NodeTransportHandler());
    }

    protected void doExecute(Task task, TermsEnumRequest request, ActionListener<TermsEnumResponse> listener) {
        this.coordinationExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<TermsEnumResponse>)l)));
    }

    private void doExecuteForked(Task task, TermsEnumRequest request, ActionListener<TermsEnumResponse> listener) {
        if (this.ccsCheckCompatibility) {
            TransportSearchHelper.checkCCSVersionCompatibility((Writeable)request);
        }
        ActionListener loggingListener = listener.delegateFailureAndWrap((l, termsEnumResponse) -> {
            ShardOperationFailedException[] deduplicated;
            for (ShardOperationFailedException e : deduplicated = ExceptionsHelper.groupBy((ShardOperationFailedException[])termsEnumResponse.getShardFailures())) {
                boolean causeHas500Status = false;
                if (e.getCause() != null) {
                    boolean bl = causeHas500Status = ExceptionsHelper.status((Throwable)e.getCause()).getStatus() >= 500;
                }
                if (e.status().getStatus() < 500 && !causeHas500Status || ExceptionsHelper.isNodeOrShardUnavailableTypeException((Throwable)e.getCause())) continue;
                logger.warn("TransportTermsEnumAction shard failure (partial results response)", (Throwable)e);
            }
            l.onResponse((Object)termsEnumResponse);
        });
        new AsyncBroadcastAction(task, request, (ActionListener<TermsEnumResponse>)loggingListener).start();
    }

    protected static NodeTermsEnumRequest newNodeRequest(OriginalIndices originalIndices, String nodeId, Set<ShardId> shardIds, TermsEnumRequest request, long taskStartMillis) {
        return new NodeTermsEnumRequest(originalIndices, nodeId, shardIds, request, taskStartMillis);
    }

    private static NodeTermsEnumResponse readShardResponse(StreamInput in) throws IOException {
        return new NodeTermsEnumResponse(in);
    }

    protected Map<String, Set<ShardId>> getNodeBundles(ClusterState clusterState, String[] concreteIndices) {
        assert (Transports.assertNotTransportThread((String)"O(#shards) work is too much for transport threads"));
        HashMap<String, Set<ShardId>> fastNodeBundles = new HashMap<String, Set<ShardId>>();
        block0: for (String indexName : concreteIndices) {
            String[] singleIndex = new String[]{indexName};
            List shards = this.clusterService.operationRouting().searchShards(clusterState, singleIndex, null, null);
            for (ShardIterator copiesOfShard : shards) {
                Set<ShardId> bundle;
                ShardRouting selectedCopyOfShard = null;
                for (ShardRouting copy : copiesOfShard) {
                    if (!copy.active() || !copy.assignedToNode()) continue;
                    selectedCopyOfShard = copy;
                    break;
                }
                if (selectedCopyOfShard == null) continue block0;
                String nodeId = selectedCopyOfShard.currentNodeId();
                if (fastNodeBundles.containsKey(nodeId)) {
                    bundle = (Set)fastNodeBundles.get(nodeId);
                } else {
                    bundle = new HashSet();
                    fastNodeBundles.put(nodeId, bundle);
                }
                if (bundle == null) continue;
                bundle.add(selectedCopyOfShard.shardId());
            }
        }
        return fastNodeBundles;
    }

    private static TermsEnumResponse mergeResponses(TermsEnumRequest request, AtomicReferenceArray<?> atomicResponses, boolean complete, Map<String, Set<ShardId>> nodeBundles) {
        assert (Transports.assertNotTransportThread((String)"O(#shards) work is too much for transport threads"));
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<List<String>> termsList = new ArrayList<List<String>>();
        for (int i = 0; i < atomicResponses.length(); ++i) {
            Object atomicResponse = atomicResponses.get(i);
            if (atomicResponse instanceof NodeTermsEnumResponse) {
                NodeTermsEnumResponse str = (NodeTermsEnumResponse)((Object)atomicResponse);
                if (!str.isComplete()) {
                    complete = false;
                }
                Set<ShardId> shards = nodeBundles.get(str.getNodeId());
                if (str.getError() != null) {
                    complete = false;
                    failedShards += shards.size();
                    if (shardFailures == null) {
                        shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                    }
                    for (ShardId failedShard : shards) {
                        shardFailures.add(new DefaultShardOperationFailedException((ElasticsearchException)new BroadcastShardOperationFailedException(failedShard, str.getError())));
                    }
                } else {
                    successfulShards += shards.size();
                }
                termsList.add(str.terms());
                continue;
            }
            if (atomicResponse instanceof RemoteClusterTermsEnumResponse) {
                RemoteClusterTermsEnumResponse rc = (RemoteClusterTermsEnumResponse)atomicResponse;
                if (!rc.resp.isComplete() || rc.resp.getFailedShards() > 0) {
                    complete = false;
                }
                successfulShards += rc.resp.getSuccessfulShards();
                failedShards += rc.resp.getFailedShards();
                for (DefaultShardOperationFailedException exc : rc.resp.getShardFailures()) {
                    if (shardFailures == null) {
                        shardFailures = new ArrayList();
                    }
                    shardFailures.add(new DefaultShardOperationFailedException(rc.clusterAlias + ":" + exc.index(), exc.shardId(), exc.getCause()));
                }
                termsList.add(rc.resp.getTerms());
                continue;
            }
            if (atomicResponse != null) {
                throw new AssertionError((Object)("Unknown atomic response type: " + atomicResponse.getClass().getName()));
            }
        }
        List<String> ans = termsList.size() == 1 ? (List<String>)termsList.get(0) : TransportTermsEnumAction.mergeResponses(termsList, request.size());
        return new TermsEnumResponse(ans, failedShards + successfulShards, successfulShards, failedShards, shardFailures, complete);
    }

    private static List<String> mergeResponses(List<List<String>> termsList, int size) {
        TermIterator it;
        PriorityQueue<TermIterator> pq = new PriorityQueue<TermIterator>(termsList.size()){

            protected boolean lessThan(TermIterator a, TermIterator b) {
                return a.compareTo(b) < 0;
            }
        };
        for (List<String> terms : termsList) {
            it = terms.iterator();
            if (!it.hasNext()) continue;
            pq.add((Object)new TermIterator(it));
        }
        String lastTerm = null;
        ArrayList<String> ans = new ArrayList<String>();
        while (pq.size() != 0) {
            it = (TermIterator)pq.top();
            String term = it.term();
            if (lastTerm != null && lastTerm.compareTo(term) != 0) {
                ans.add(lastTerm);
                if (ans.size() == size) break;
                lastTerm = null;
            }
            if (lastTerm == null) {
                lastTerm = term;
            }
            if (it.hasNext()) {
                String itTerm = it.term();
                it.next();
                assert (itTerm.compareTo(it.term()) <= 0);
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (lastTerm != null && ans.size() < size) {
            ans.add(lastTerm);
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeTermsEnumResponse dataNodeOperation(NodeTermsEnumRequest request) throws IOException {
        Object object;
        ArrayList<String> termsList = new ArrayList<String>();
        long timeout_millis = request.timeout();
        long scheduledEnd = request.nodeStartedTimeMillis() + timeout_millis;
        ArrayList<Engine.Searcher> openedResources = new ArrayList<Engine.Searcher>();
        try {
            NodeTermsEnumResponse nodeTermsEnumResponse;
            Object indexService;
            MultiShardTermsEnum.Builder teBuilder = new MultiShardTermsEnum.Builder();
            for (ShardId shardId : request.shardIds()) {
                TermsEnum terms;
                if (System.currentTimeMillis() > scheduledEnd) {
                    NodeTermsEnumResponse nodeTermsEnumResponse2 = NodeTermsEnumResponse.partial(request.nodeId(), termsList);
                    return nodeTermsEnumResponse2;
                }
                indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
                IndexShard indexShard = indexService.getShard(shardId.getId());
                Engine.Searcher searcher = indexShard.acquireSearcher("search");
                openedResources.add(searcher);
                MappedFieldType mappedFieldType = indexShard.mapperService().fieldType(request.field());
                if (mappedFieldType == null || (terms = mappedFieldType.getTerms(searcher.getIndexReader(), request.string() == null ? "" : request.string(), request.caseInsensitive(), request.searchAfter())) == null) continue;
                teBuilder.add(terms, arg_0 -> ((MappedFieldType)mappedFieldType).valueForDisplay(arg_0));
            }
            if (teBuilder.size() == 0) {
                object = NodeTermsEnumResponse.empty(request.nodeId());
                return object;
            }
            MultiShardTermsEnum te = teBuilder.build();
            int shard_size = request.size();
            if (System.currentTimeMillis() > scheduledEnd) {
                indexService = NodeTermsEnumResponse.partial(request.nodeId(), termsList);
                return indexService;
            }
            int numTermsBetweenClockChecks = 100;
            int termCount = 0;
            while (te.next() != null) {
                if (++termCount > numTermsBetweenClockChecks) {
                    if (System.currentTimeMillis() > scheduledEnd) {
                        nodeTermsEnumResponse = NodeTermsEnumResponse.partial(request.nodeId(), termsList);
                        return nodeTermsEnumResponse;
                    }
                    termCount = 0;
                }
                termsList.add(te.decodedTerm());
                if (termsList.size() < shard_size) continue;
            }
            nodeTermsEnumResponse = NodeTermsEnumResponse.complete(request.nodeId(), termsList);
            return nodeTermsEnumResponse;
        }
        catch (Exception e) {
            object = NodeTermsEnumResponse.error(request.nodeId(), termsList, e);
            return object;
        }
        finally {
            IOUtils.close(openedResources);
        }
    }

    private boolean canAccess(ShardId shardId, NodeTermsEnumRequest request, XPackLicenseState frozenLicenseState, ThreadContext threadContext) {
        IndicesAccessControl indicesAccessControl;
        IndicesAccessControl.IndexAccessControl indexAccessControl;
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue() && (indexAccessControl = (indicesAccessControl = (IndicesAccessControl)threadContext.getTransient("_indices_permissions")).getIndexPermissions(shardId.getIndexName())) != null && indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions() && SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(frozenLicenseState)) {
            SecurityContext securityContext = new SecurityContext(this.clusterService.getSettings(), threadContext);
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            SearchExecutionContext queryShardContext = indexService.newSearchExecutionContext(shardId.id(), 0, null, request::nodeStartedTimeMillis, null, Collections.emptyMap());
            List<Set<BytesReference>> listOfQueries = indexAccessControl.getDocumentPermissions().getListOfQueries();
            return listOfQueries.stream().allMatch(queries -> this.hasMatchAllEquivalent((Set<BytesReference>)queries, securityContext, queryShardContext));
        }
        return true;
    }

    private boolean hasMatchAllEquivalent(Set<BytesReference> queries, SecurityContext securityContext, SearchExecutionContext queryShardContext) {
        if (queries == null) {
            return true;
        }
        for (BytesReference querySource : queries) {
            QueryBuilder rewrittenQueryBuilder;
            QueryBuilder queryBuilder = DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(querySource, this.scriptService, queryShardContext.getParserConfig().registry(), securityContext.getUser());
            try {
                rewrittenQueryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)queryShardContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (!(rewrittenQueryBuilder instanceof MatchAllQueryBuilder)) continue;
            return true;
        }
        return false;
    }

    private boolean canMatchShard(ShardId shardId, NodeTermsEnumRequest req) {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        ShardSearchRequest searchRequest = new ShardSearchRequest(shardId, req.nodeStartedTimeMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return this.searchService.canMatch(searchRequest).canMatch();
    }

    private void asyncNodeOperation(NodeTermsEnumRequest request, ActionListener<NodeTermsEnumResponse> listener) throws IOException {
        request.startTimerOnDataNode();
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
        for (ShardId shardId : request.shardIds().toArray(new ShardId[0])) {
            if (this.canAccess(shardId, request, frozenLicenseState, threadContext) && this.canMatchShard(shardId, request)) continue;
            request.remove(shardId);
        }
        if (request.shardIds().size() == 0) {
            listener.onResponse((Object)NodeTermsEnumResponse.empty(request.nodeId()));
        } else {
            assert (this.transportService.getThreadPool().executor("search") instanceof EsThreadPoolExecutor) : "SEARCH threadpool must be an instance of ThreadPoolExecutor";
            EsThreadPoolExecutor ex = (EsThreadPoolExecutor)this.transportService.getThreadPool().executor("search");
            Object executor = ex.getQueue().size() == 0 ? ex : this.shardExecutor;
            executor.execute((Runnable)ActionRunnable.supply(listener, () -> this.dataNodeOperation(request)));
        }
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeTermsEnumRequest> {
        NodeTransportHandler() {
        }

        public void messageReceived(NodeTermsEnumRequest request, TransportChannel channel, Task task) throws Exception {
            TransportTermsEnumAction.this.asyncNodeOperation(request, (ActionListener<NodeTermsEnumResponse>)ActionListener.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception e1) {
                    logger.warn(() -> Strings.format((String)"Failed to send error response for action [%s] and request [%s]", (Object[])new Object[]{TransportTermsEnumAction.this.actionName, request}), (Throwable)e1);
                }
            }));
        }
    }

    protected class AsyncBroadcastAction {
        private final Task task;
        private final TermsEnumRequest request;
        private ActionListener<TermsEnumResponse> listener;
        private final DiscoveryNodes nodes;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray<Object> atomicResponses;
        private final Map<String, Set<ShardId>> nodeBundles;
        private final OriginalIndices localIndices;
        private final Map<String, OriginalIndices> remoteClusterIndices;

        protected AsyncBroadcastAction(Task task, TermsEnumRequest request, ActionListener<TermsEnumResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = TransportTermsEnumAction.this.clusterService.state();
            ClusterBlockException blockException = clusterState.blocks().globalBlockedException(ClusterBlockLevel.READ);
            if (blockException != null) {
                throw blockException;
            }
            this.remoteClusterIndices = TransportTermsEnumAction.this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices());
            this.localIndices = this.remoteClusterIndices.remove("");
            String[] concreteIndices = this.localIndices == null ? new String[]{} : TransportTermsEnumAction.this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)this.localIndices);
            blockException = clusterState.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = clusterState.nodes();
            logger.trace("resolving shards based on cluster state version [{}]", (Object)clusterState.version());
            this.nodeBundles = TransportTermsEnumAction.this.getNodeBundles(clusterState, concreteIndices);
            this.expectedOps = this.nodeBundles.size() + this.remoteClusterIndices.size();
            this.atomicResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.expectedOps == 0) {
                try {
                    this.listener.onResponse((Object)TransportTermsEnumAction.mergeResponses(this.request, new AtomicReferenceArray(0), true, this.nodeBundles));
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
                return;
            }
            int numOps = 0;
            for (String nodeId : this.nodeBundles.keySet()) {
                if (this.checkForEarlyFinish()) {
                    return;
                }
                Set<ShardId> shardIds = this.nodeBundles.get(nodeId);
                if (shardIds.size() > 0) {
                    this.performOperation(nodeId, shardIds, numOps);
                } else {
                    this.onNodeFailure(nodeId, numOps, null);
                }
                ++numOps;
            }
            for (String clusterAlias : this.remoteClusterIndices.keySet()) {
                this.performRemoteClusterOperation(clusterAlias, this.remoteClusterIndices.get(clusterAlias), numOps);
                ++numOps;
            }
        }

        boolean checkForEarlyFinish() {
            long now = System.currentTimeMillis();
            if (now - this.task.getStartTime() > this.request.timeout().getMillis()) {
                this.finishHim(false);
                return true;
            }
            return false;
        }

        protected void performOperation(final String nodeId, Set<ShardId> shardIds, final int opsIndex) {
            if (shardIds.size() == 0) {
                this.onNodeFailure(nodeId, opsIndex, null);
            } else {
                try {
                    NodeTermsEnumRequest nodeRequest = TransportTermsEnumAction.newNodeRequest(this.localIndices, nodeId, shardIds, this.request, this.task.getStartTime());
                    nodeRequest.setParentTask(TransportTermsEnumAction.this.clusterService.localNode().getId(), this.task.getId());
                    DiscoveryNode node = this.nodes.get(nodeId);
                    if (node == null) {
                        this.onNodeFailure(nodeId, opsIndex, null);
                    } else if (!this.checkForEarlyFinish()) {
                        TransportTermsEnumAction.this.transportService.sendRequest(node, TransportTermsEnumAction.this.transportShardAction, (TransportRequest)nodeRequest, (TransportResponseHandler)new TransportResponseHandler<NodeTermsEnumResponse>(){

                            public NodeTermsEnumResponse read(StreamInput in) throws IOException {
                                return TransportTermsEnumAction.readShardResponse(in);
                            }

                            public Executor executor() {
                                return TransportTermsEnumAction.this.coordinationExecutor;
                            }

                            public void handleResponse(NodeTermsEnumResponse response) {
                                AsyncBroadcastAction.this.onNodeResponse(nodeId, opsIndex, response);
                            }

                            public void handleException(TransportException exc) {
                                AsyncBroadcastAction.this.onNodeFailure(nodeId, opsIndex, (Exception)exc);
                            }
                        });
                    }
                }
                catch (Exception exc) {
                    this.onNodeFailure(nodeId, opsIndex, exc);
                }
            }
        }

        void performRemoteClusterOperation(final String clusterAlias, OriginalIndices remoteIndices, final int opsIndex) {
            try {
                TermsEnumRequest req = (TermsEnumRequest)new TermsEnumRequest(this.request).indices(remoteIndices.indices());
                RemoteClusterClient remoteClient = TransportTermsEnumAction.this.remoteClusterService.getRemoteClusterClient(clusterAlias, TransportTermsEnumAction.this.coordinationExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
                remoteClient.execute(TermsEnumAction.REMOTE_TYPE, (ActionRequest)req, (ActionListener)new ActionListener<TermsEnumResponse>(){

                    public void onResponse(TermsEnumResponse termsEnumResponse) {
                        AsyncBroadcastAction.this.onRemoteClusterResponse(clusterAlias, opsIndex, new RemoteClusterTermsEnumResponse(clusterAlias, termsEnumResponse));
                    }

                    public void onFailure(Exception exc) {
                        AsyncBroadcastAction.this.onRemoteClusterFailure(clusterAlias, opsIndex, exc);
                    }
                });
            }
            catch (Exception exc) {
                this.onRemoteClusterFailure(clusterAlias, opsIndex, null);
            }
        }

        private void onNodeResponse(String nodeId, int opsIndex, NodeTermsEnumResponse response) {
            logger.trace("received response for node {}", (Object)nodeId);
            this.atomicResponses.set(opsIndex, (Object)response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            } else {
                this.checkForEarlyFinish();
            }
        }

        private void onRemoteClusterResponse(String clusterAlias, int opsIndex, RemoteClusterTermsEnumResponse response) {
            logger.trace("received response for cluster {}", (Object)clusterAlias);
            this.atomicResponses.set(opsIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            } else {
                this.checkForEarlyFinish();
            }
        }

        private void onNodeFailure(String nodeId, int opsIndex, Exception exc) {
            logger.trace("received failure {} for node {}", (Object)exc, (Object)nodeId);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            }
        }

        private void onRemoteClusterFailure(String clusterAlias, int opsIndex, Exception exc) {
            logger.trace("received failure {} for cluster {}", (Object)exc, (Object)clusterAlias);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            }
        }

        protected synchronized void finishHim(boolean complete) {
            if (this.listener == null) {
                return;
            }
            try {
                this.listener.onResponse((Object)TransportTermsEnumAction.mergeResponses(this.request, this.atomicResponses, complete, this.nodeBundles));
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
            finally {
                this.listener = null;
            }
        }
    }

    private record RemoteClusterTermsEnumResponse(String clusterAlias, TermsEnumResponse resp) {
    }

    private static class TermIterator
    implements Iterator<String>,
    Comparable<TermIterator> {
        private final Iterator<String> iterator;
        private String current;

        private TermIterator(Iterator<String> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }

        public String term() {
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public int compareTo(TermIterator o) {
            return this.current.compareTo(o.term());
        }
    }
}

