/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetProfilesRequest
extends LegacyActionRequest {
    private final List<String> uids;
    private final Set<String> dataKeys;

    public GetProfilesRequest(List<String> uids, Set<String> dataKeys) {
        this.uids = Objects.requireNonNull(uids, "profile UIDs cannot be null");
        this.dataKeys = Objects.requireNonNull(dataKeys, "data keys cannot be null");
    }

    public GetProfilesRequest(StreamInput in) throws IOException {
        super(in);
        this.uids = in.readStringCollectionAsList();
        this.dataKeys = in.readCollectionAsSet(StreamInput::readString);
    }

    public GetProfilesRequest(String uid, Set<String> dataKeys) {
        this(List.of(Objects.requireNonNull(uid, "profile UID cannot be null")), dataKeys);
    }

    public List<String> getUids() {
        return this.uids;
    }

    public Set<String> getDataKeys() {
        return this.dataKeys;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.uids);
        out.writeStringCollection(this.dataKeys);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.uids.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"profile UIDs must be provided", validationException);
        }
        if (this.uids.stream().anyMatch(uid -> false == Strings.hasText((String)uid))) {
            validationException = ValidateActions.addValidationError((String)"Profile UID cannot be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

