/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;

public final class GetPrivilegesRequest
extends LegacyActionRequest
implements ApplicationPrivilegesRequest {
    @Nullable
    private String application;
    private String[] privileges;

    public GetPrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.application = in.readOptionalString();
        this.privileges = in.readStringArray();
    }

    public GetPrivilegesRequest() {
        this.privileges = Strings.EMPTY_ARRAY;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.privileges == null) {
            validationException = ValidateActions.addValidationError((String)"privileges cannot be null", validationException);
        }
        return validationException;
    }

    public void application(String application) {
        this.application = application;
    }

    public String application() {
        return this.application;
    }

    @Override
    public Collection<String> getApplicationNames() {
        return this.application == null ? Collections.emptySet() : Collections.singleton(this.application);
    }

    public void privileges(String ... privileges) {
        this.privileges = privileges;
    }

    public String[] privileges() {
        return this.privileges;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.application);
        out.writeStringArray(this.privileges);
    }
}

