/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;

public final class DeletePrivilegesRequest
extends LegacyActionRequest
implements ApplicationPrivilegesRequest,
WriteRequest<DeletePrivilegesRequest> {
    private String application;
    private String[] privileges;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public DeletePrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.application = in.readString();
        this.privileges = in.readStringArray();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public DeletePrivilegesRequest() {
        this(null, Strings.EMPTY_ARRAY);
    }

    public DeletePrivilegesRequest(String application, String[] privileges) {
        this.application = application;
        this.privileges = privileges;
    }

    public DeletePrivilegesRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.application)) {
            validationException = ValidateActions.addValidationError((String)"application name is missing", validationException);
        }
        if (this.privileges == null || this.privileges.length == 0 || Arrays.stream(this.privileges).allMatch(Strings::isNullOrEmpty)) {
            validationException = ValidateActions.addValidationError((String)"privileges are missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void application(String application) {
        this.application = application;
    }

    public String application() {
        return this.application;
    }

    @Override
    public Collection<String> getApplicationNames() {
        return Collections.singleton(this.application);
    }

    public String[] privileges() {
        return this.privileges;
    }

    public void privileges(String[] privileges) {
        this.privileges = privileges;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.application);
        out.writeStringArray(this.privileges);
        this.refreshPolicy.writeTo(out);
    }
}

