/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Parameters
implements Writeable,
ToXContentObject {
    public static final ParseField N_NEIGHBORS = new ParseField("n_neighbors", new String[0]);
    public static final ParseField METHOD = new ParseField("method", new String[0]);
    public static final ParseField FEATURE_INFLUENCE_THRESHOLD = new ParseField("feature_influence_threshold", new String[0]);
    public static final ParseField COMPUTE_FEATURE_INFLUENCE = new ParseField("compute_feature_influence", new String[0]);
    public static final ParseField OUTLIER_FRACTION = new ParseField("outlier_fraction", new String[0]);
    public static final ParseField STANDARDIZATION_ENABLED = new ParseField("standardization_enabled", new String[0]);
    private final int nNeighbors;
    private final String method;
    private final boolean computeFeatureInfluence;
    private final double featureInfluenceThreshold;
    private final double outlierFraction;
    private final boolean standardizationEnabled;

    public static Parameters fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return (Parameters)Parameters.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<Parameters, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("outlier_detection_parameters", ignoreUnknownFields, a -> new Parameters((Integer)a[0], (String)a[1], (Boolean)a[2], (Double)a[3], (Double)a[4], (Boolean)a[5]));
        parser.declareInt(ConstructingObjectParser.constructorArg(), N_NEIGHBORS);
        parser.declareString(ConstructingObjectParser.constructorArg(), METHOD);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), COMPUTE_FEATURE_INFLUENCE);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), FEATURE_INFLUENCE_THRESHOLD);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), OUTLIER_FRACTION);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), STANDARDIZATION_ENABLED);
        return parser;
    }

    public Parameters(int nNeighbors, String method, boolean computeFeatureInfluence, double featureInfluenceThreshold, double outlierFraction, boolean standardizationEnabled) {
        this.nNeighbors = nNeighbors;
        this.method = method;
        this.computeFeatureInfluence = computeFeatureInfluence;
        this.featureInfluenceThreshold = featureInfluenceThreshold;
        this.outlierFraction = outlierFraction;
        this.standardizationEnabled = standardizationEnabled;
    }

    public Parameters(StreamInput in) throws IOException {
        this.nNeighbors = in.readVInt();
        this.method = in.readString();
        this.computeFeatureInfluence = in.readBoolean();
        this.featureInfluenceThreshold = in.readDouble();
        this.outlierFraction = in.readDouble();
        this.standardizationEnabled = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.nNeighbors);
        out.writeString(this.method);
        out.writeBoolean(this.computeFeatureInfluence);
        out.writeDouble(this.featureInfluenceThreshold);
        out.writeDouble(this.outlierFraction);
        out.writeBoolean(this.standardizationEnabled);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        builder.field(METHOD.getPreferredName(), this.method);
        builder.field(COMPUTE_FEATURE_INFLUENCE.getPreferredName(), this.computeFeatureInfluence);
        builder.field(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        builder.field(OUTLIER_FRACTION.getPreferredName(), this.outlierFraction);
        builder.field(STANDARDIZATION_ENABLED.getPreferredName(), this.standardizationEnabled);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameters that = (Parameters)o;
        return this.nNeighbors == that.nNeighbors && Objects.equals(this.method, that.method) && this.computeFeatureInfluence == that.computeFeatureInfluence && this.featureInfluenceThreshold == that.featureInfluenceThreshold && this.outlierFraction == that.outlierFraction && this.standardizationEnabled == that.standardizationEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.nNeighbors, this.method, this.computeFeatureInfluence, this.featureInfluenceThreshold, this.outlierFraction, this.standardizationEnabled);
    }
}

