/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PutFilterAction
extends ActionType<Response> {
    public static final PutFilterAction INSTANCE = new PutFilterAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/put";

    private PutFilterAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final MlFilter filter;

        Response(StreamInput in) throws IOException {
            super(in);
            this.filter = new MlFilter(in);
        }

        public Response(MlFilter filter) {
            this.filter = filter;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.filter.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.filter.toXContent(builder, params);
        }

        public MlFilter getFilter() {
            return this.filter;
        }

        public int hashCode() {
            return Objects.hash(this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.filter, other.filter);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final MlFilter filter;

        public static Request parseRequest(String filterId, XContentParser parser) {
            MlFilter.Builder filter = (MlFilter.Builder)MlFilter.STRICT_PARSER.apply(parser, null);
            if (filter.getId() == null) {
                filter.setId(filterId);
            } else if (!Strings.isNullOrEmpty((String)filterId) && !filterId.equals(filter.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", MlFilter.ID.getPreferredName(), filter.getId(), filterId));
            }
            return new Request(filter.build());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.filter = new MlFilter(in);
        }

        public Request(MlFilter filter) {
            this.filter = ExceptionsHelper.requireNonNull(filter, "filter");
        }

        public MlFilter getFilter() {
            return this.filter;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.filter.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.filter.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.filter, other.filter);
        }
    }
}

