/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PostCalendarEventsAction
extends ActionType<Response> {
    public static final PostCalendarEventsAction INSTANCE = new PostCalendarEventsAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/events/post";
    public static final ParseField EVENTS = new ParseField("events", new String[0]);

    private PostCalendarEventsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<ScheduledEvent> scheduledEvents;

        public Response(List<ScheduledEvent> scheduledEvents) {
            this.scheduledEvents = scheduledEvents;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.scheduledEvents);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(EVENTS.getPreferredName(), this.scheduledEvents);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.scheduledEvents);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.scheduledEvents, other.scheduledEvents);
        }
    }

    public static class Request
    extends LegacyActionRequest {
        private static final ObjectParser<List<ScheduledEvent.Builder>, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/calendars/events/post", ArrayList::new);
        private final String calendarId;
        private final List<ScheduledEvent> scheduledEvents;

        public static Request parseRequest(String calendarId, XContentParser parser) throws IOException {
            List events = (List)PARSER.apply(parser, null);
            for (ScheduledEvent.Builder event : events) {
                if (event.getCalendarId() != null && !event.getCalendarId().equals(calendarId)) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Calendar.ID.getPreferredName(), event.getCalendarId(), calendarId), new Object[0]);
                }
                event.calendarId(calendarId);
            }
            return new Request(calendarId, events.stream().map(ScheduledEvent.Builder::build).collect(Collectors.toList()));
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readString();
            this.scheduledEvents = in.readCollectionAsList(ScheduledEvent::new);
        }

        public Request(String calendarId, List<ScheduledEvent> scheduledEvents) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
            this.scheduledEvents = ExceptionsHelper.requireNonNull(scheduledEvents, EVENTS.getPreferredName());
            if (scheduledEvents.isEmpty()) {
                throw ExceptionsHelper.badRequestException("At least 1 event is required", new Object[0]);
            }
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public List<ScheduledEvent> getScheduledEvents() {
            return this.scheduledEvents;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeCollection(this.scheduledEvents);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.scheduledEvents);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.scheduledEvents, other.scheduledEvents);
        }

        static {
            PARSER.declareObjectArray(List::addAll, (p, c) -> (ScheduledEvent.Builder)ScheduledEvent.STRICT_PARSER.apply(p, null), ScheduledEvent.RESULTS_FIELD);
        }
    }
}

