/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.IndexNameGenerator;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionStateUtils;
import org.elasticsearch.xpack.core.ilm.Step;

public class GenerateUniqueIndexNameStep
extends ClusterStateActionStep {
    private static final Logger logger = LogManager.getLogger(GenerateUniqueIndexNameStep.class);
    public static final String NAME = "generate-index-name";
    private final String prefix;
    private final BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter;

    public GenerateUniqueIndexNameStep(Step.StepKey key, Step.StepKey nextStepKey, String prefix, BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter) {
        super(key, nextStepKey);
        this.prefix = prefix;
        this.lifecycleStateSetter = lifecycleStateSetter;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    String prefix() {
        return this.prefix;
    }

    BiFunction<String, LifecycleExecutionState.Builder, LifecycleExecutionState.Builder> lifecycleStateSetter() {
        return this.lifecycleStateSetter;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState);
        String policyName = indexMetadata.getLifecyclePolicyName();
        String generatedIndexName = this.generateIndexName(this.prefix, index.getName());
        ActionRequestValidationException validationException = IndexNameGenerator.validateGeneratedIndexName((String)generatedIndexName, (ClusterState)clusterState);
        if (validationException != null) {
            logger.warn("unable to generate a valid index name as part of policy [{}] for index [{}] due to [{}]", (Object)policyName, (Object)index.getName(), (Object)validationException.getMessage());
            throw validationException;
        }
        this.lifecycleStateSetter.apply(generatedIndexName, newLifecycleState);
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState(clusterState, indexMetadata.getIndex(), newLifecycleState.build());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateUniqueIndexNameStep that = (GenerateUniqueIndexNameStep)o;
        return super.equals(o) && Objects.equals(this.prefix, that.prefix);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefix);
    }

    public String generateIndexName(String prefix, String indexName) {
        return IndexNameGenerator.generateValidIndexName((String)prefix, (String)indexName);
    }
}

