/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.application;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public final class LogsDBFeatureSetUsage
extends XPackFeatureUsage {
    private final int indicesCount;
    private final int indicesWithSyntheticSource;
    private final long numDocs;
    private final long sizeInBytes;
    private final boolean hasCustomCutoffDate;

    public LogsDBFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.indicesCount = input.readVInt();
        this.indicesWithSyntheticSource = input.readVInt();
        if (input.getTransportVersion().onOrAfter((VersionId)TransportVersions.LOGSDB_TELEMETRY_STATS)) {
            this.numDocs = input.readVLong();
            this.sizeInBytes = input.readVLong();
        } else {
            this.numDocs = 0L;
            this.sizeInBytes = 0L;
        }
        TransportVersion transportVersion = input.getTransportVersion();
        this.hasCustomCutoffDate = transportVersion.isPatchFrom(TransportVersions.LOGSDB_TELEMETRY_CUSTOM_CUTOFF_DATE_FIX_8_17) || transportVersion.supports(TransportVersions.V_8_18_0) ? input.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportVersion transportVersion;
        super.writeTo(out);
        out.writeVInt(this.indicesCount);
        out.writeVInt(this.indicesWithSyntheticSource);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.LOGSDB_TELEMETRY_STATS)) {
            out.writeVLong(this.numDocs);
            out.writeVLong(this.sizeInBytes);
        }
        if ((transportVersion = out.getTransportVersion()).isPatchFrom(TransportVersions.LOGSDB_TELEMETRY_CUSTOM_CUTOFF_DATE_FIX_8_17) || transportVersion.supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(this.hasCustomCutoffDate);
        }
    }

    public LogsDBFeatureSetUsage(boolean available, boolean enabled, int indicesCount, int indicesWithSyntheticSource, long numDocs, long sizeInBytes, boolean hasCustomCutoffDate) {
        super("logsdb", available, enabled);
        this.indicesCount = indicesCount;
        this.indicesWithSyntheticSource = indicesWithSyntheticSource;
        this.numDocs = numDocs;
        this.sizeInBytes = sizeInBytes;
        this.hasCustomCutoffDate = hasCustomCutoffDate;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.LOGSDB_TELEMETRY;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("indices_count", this.indicesCount);
        builder.field("indices_with_synthetic_source", this.indicesWithSyntheticSource);
        builder.field("num_docs", this.numDocs);
        builder.field("size_in_bytes", this.sizeInBytes);
        builder.field("has_custom_cutoff_date", this.hasCustomCutoffDate);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.indicesCount, this.indicesWithSyntheticSource, this.numDocs, this.sizeInBytes, this.hasCustomCutoffDate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogsDBFeatureSetUsage other = (LogsDBFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.indicesCount, other.indicesCount) && Objects.equals(this.indicesWithSyntheticSource, other.indicesWithSyntheticSource) && Objects.equals(this.numDocs, other.numDocs) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.hasCustomCutoffDate, other.hasCustomCutoffDate);
    }
}

