/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.session;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class Configuration {
    protected final String clusterName;
    protected final String username;
    protected final ZonedDateTime now;
    protected final ZoneId zoneId;

    public Configuration(ZoneId zi, String username, String clusterName) {
        this(zi, null, username, clusterName);
    }

    protected Configuration(ZoneId zi, Instant now, String username, String clusterName) {
        this.zoneId = zi.normalized();
        this.now = now != null ? now.atZone(zi) : ZonedDateTime.now(Clock.tick(Clock.system(this.zoneId), Duration.ofNanos(1L)));
        this.username = username;
        this.clusterName = clusterName;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public ZonedDateTime now() {
        return this.now;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String username() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.now, that.now) && Objects.equals(this.username, that.username) && Objects.equals(this.clusterName, that.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.now, this.username, this.clusterName);
    }
}

