/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteConnectionStrategy;

public final class RemoteClusterResolver
extends RemoteClusterAware {
    private final CopyOnWriteArraySet<String> clusters;

    public RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.getEnabledRemoteClusters((Settings)settings));
        this.listenForUpdates(clusterSettings);
    }

    protected void updateRemoteCluster(String clusterAlias, Settings settings) {
        if (RemoteConnectionStrategy.isConnectionEnabled((String)clusterAlias, (Settings)settings)) {
            this.clusters.add(clusterAlias);
        } else {
            this.clusters.remove(clusterAlias);
        }
    }

    public Set<String> remoteClusters() {
        return new TreeSet<String>(this.clusters);
    }
}

