/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.InferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.rest.inference.RestInferTrainedModelAction;

public class RestInferTrainedModelDeploymentAction
extends BaseRestHandler {
    static final String PATH = "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID.getPreferredName() + "}/deployment/_infer";

    public String getName() {
        return "xpack_ml_infer_trained_models_deployment_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)PATH).deprecated("[" + RestRequest.Method.POST.name() + " " + PATH + "] is deprecated! Use [" + RestRequest.Method.POST.name() + " " + RestInferTrainedModelAction.PATH + "] instead.", RestApiVersion.V_8).build());
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        InferModelAction.Request request;
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (!restRequest.hasContent()) {
            throw ExceptionsHelper.badRequestException((String)"requires body", (Object[])new Object[0]);
        }
        InferModelAction.Request.Builder requestBuilder = InferModelAction.Request.parseRequest((String)modelId, (XContentParser)restRequest.contentParser());
        if (restRequest.hasParam(InferModelAction.Request.TIMEOUT.getPreferredName())) {
            TimeValue inferTimeout = restRequest.paramAsTime(InferModelAction.Request.TIMEOUT.getPreferredName(), InferModelAction.Request.DEFAULT_TIMEOUT_FOR_API);
            requestBuilder.setInferenceTimeout(inferTimeout);
        }
        if ((request = requestBuilder.build()).getObjectsToInfer() != null && request.getObjectsToInfer().size() > 1) {
            ValidationException ex = new ValidationException();
            ex.addValidationError("multiple documents are not supported");
            throw ex;
        }
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)InferModelAction.EXTERNAL_INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
            InferTrainedModelDeploymentAction.Response oldResponse = new InferTrainedModelDeploymentAction.Response(response.getInferenceResults());
            new RestToXContentListener(channel).onResponse((Object)oldResponse);
        }, e -> new RestToXContentListener(channel).onFailure(e)));
    }
}

