/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.util.Locale;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NerConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ZeroShotClassificationConfig;
import org.elasticsearch.xpack.ml.inference.nlp.FillMaskProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.NerProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.NlpTask;
import org.elasticsearch.xpack.ml.inference.nlp.PassThroughProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.QuestionAnsweringProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextClassificationProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextEmbeddingProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextExpansionProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.TextSimilarityProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.ZeroShotClassificationProcessor;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.NlpTokenizer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskType {
    NER{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new NerProcessor(tokenizer, (NerConfig)config);
        }
    }
    ,
    TEXT_CLASSIFICATION{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextClassificationProcessor(tokenizer, (TextClassificationConfig)config);
        }
    }
    ,
    FILL_MASK{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new FillMaskProcessor(tokenizer);
        }
    }
    ,
    PASS_THROUGH{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new PassThroughProcessor(tokenizer);
        }
    }
    ,
    TEXT_EMBEDDING{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextEmbeddingProcessor(tokenizer);
        }
    }
    ,
    ZERO_SHOT_CLASSIFICATION{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new ZeroShotClassificationProcessor(tokenizer, (ZeroShotClassificationConfig)config);
        }
    }
    ,
    QUESTION_ANSWERING{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new QuestionAnsweringProcessor(tokenizer);
        }
    }
    ,
    TEXT_SIMILARITY{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextSimilarityProcessor(tokenizer);
        }
    }
    ,
    TEXT_EXPANSION{

        @Override
        public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
            return new TextExpansionProcessor(tokenizer);
        }
    };


    public NlpTask.Processor createProcessor(NlpTokenizer tokenizer, NlpConfig config) {
        throw new UnsupportedOperationException("json request must be specialised for task type [" + this.name() + "]");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static TaskType fromString(String name) {
        return TaskType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }
}

