/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.util.Arrays;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.FastMath;

final class KDE {
    private static final double SQRT2 = FastMath.sqrt((double)2.0);
    private static final double ESTIMATOR_EPS = 1.0E-10;
    private final double[] orderedValues;
    private final double bandwidth;

    private static int lowerBound(double[] xs, double x) {
        int retVal = Arrays.binarySearch(xs, x);
        if (retVal < 0) {
            retVal = -1 - retVal;
        }
        return retVal;
    }

    private ValueAndMagnitude evaluate(IntervalComplementFunction complement, KernelFunction kernel, double x) {
        if (this.bandwidth == 0.0 || this.orderedValues.length == 0) {
            return new ValueAndMagnitude(1.0, 0.0);
        }
        int a = Math.min(KDE.lowerBound(this.orderedValues, x - 3.0 * this.bandwidth), this.orderedValues.length - 1);
        int b = Math.max(KDE.lowerBound(this.orderedValues, x + 3.0 * this.bandwidth), a + 1);
        double kdfx = complement.value(a, b);
        double diff = Double.MAX_VALUE;
        for (int i = a; i < b; ++i) {
            double centre = this.orderedValues[i];
            kdfx += kernel.value(centre, x);
            diff = Math.min(Math.abs(centre - x), diff);
        }
        return new ValueAndMagnitude(kdfx / (double)this.orderedValues.length, diff);
    }

    KDE(double[] orderedValues, double smoothing) {
        for (int i = 1; i < orderedValues.length; ++i) {
            if (!(orderedValues[i - 1] > orderedValues[i])) continue;
            throw new IllegalArgumentException("Values must be ordered ascending, got [" + Arrays.toString(orderedValues) + "].");
        }
        this.orderedValues = orderedValues;
        this.bandwidth = smoothing * Math.pow(orderedValues.length, -0.2) * Math.sqrt(StatUtils.variance((double[])orderedValues));
    }

    ValueAndMagnitude cdf(double x) {
        return this.evaluate((a, b) -> a, (centre, x_) -> this.normCdf(centre, x_), x);
    }

    ValueAndMagnitude sf(double x) {
        return this.evaluate((a, b) -> this.orderedValues.length - b, (centre, x_) -> this.normSf(centre, x_), x);
    }

    double normCdf(double mean, double x) {
        double dev = x - mean;
        if (Math.abs(dev) > 40.0 * this.bandwidth) {
            return dev > 0.0 ? 1.0 : 0.0;
        }
        return 0.5 * Erf.erfc((double)(-dev / (this.bandwidth * SQRT2)));
    }

    double normSf(double mean, double x) {
        double dev = x - mean;
        if (Math.abs(dev) > 40.0 * this.bandwidth) {
            return dev > 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * Erf.erfc((double)(dev / (this.bandwidth * SQRT2)));
    }

    int size() {
        return this.orderedValues.length;
    }

    double[] data() {
        return this.orderedValues;
    }

    record ValueAndMagnitude(double value, double magnitude) {
        boolean isMoreSignificant(ValueAndMagnitude o) {
            int c = Double.compare(this.value, o.value());
            return c != 0 ? c < 0 : this.magnitude > o.magnitude;
        }

        double pValue(int numberOfTestedValues) {
            return this.value > 1.0E-10 ? 1.0 - Math.pow(1.0 - this.value, numberOfTestedValues) : (double)numberOfTestedValues * this.value;
        }
    }

    private static interface IntervalComplementFunction {
        public double value(int var1, int var2);
    }

    private static interface KernelFunction {
        public double value(double var1, double var3);
    }
}

