/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPreviewDatafeedAction
extends HandledTransportAction<PreviewDatafeedAction.Request, PreviewDatafeedAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final SecurityContext securityContext;

    @Inject
    public TransportPreviewDatafeedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeeds/preview", transportService, actionFilters, PreviewDatafeedAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService = clusterService;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.xContentRegistry = xContentRegistry;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void doExecute(Task task, PreviewDatafeedAction.Request request, ActionListener<PreviewDatafeedAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ActionListener datafeedConfigActionListener = listener.delegateFailureAndWrap((delegate, datafeedConfig) -> {
            if (request.getJobConfig() != null) {
                this.previewDatafeed(parentTaskId, (DatafeedConfig)datafeedConfig, request.getJobConfig().build(new Date()), request, (ActionListener<PreviewDatafeedAction.Response>)delegate);
                return;
            }
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), parentTaskId, (ActionListener<Job.Builder>)delegate.delegateFailureAndWrap((l, jobBuilder) -> this.previewDatafeed(parentTaskId, (DatafeedConfig)datafeedConfig, jobBuilder.build(), request, (ActionListener<PreviewDatafeedAction.Response>)l)));
        });
        if (request.getDatafeedConfig() != null) {
            datafeedConfigActionListener.onResponse((Object)request.getDatafeedConfig());
        } else {
            this.datafeedConfigProvider.getDatafeedConfig(request.getDatafeedId(), parentTaskId, (ActionListener<DatafeedConfig.Builder>)datafeedConfigActionListener.delegateFailureAndWrap((l, builder) -> l.onResponse((Object)builder.build())));
        }
    }

    private void previewDatafeed(TaskId parentTaskId, DatafeedConfig datafeedConfig, Job job, PreviewDatafeedAction.Request request, ActionListener<PreviewDatafeedAction.Response> listener) {
        ContextPreservingActionListener responseHeaderPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadPool.getThreadContext());
        BoolQueryBuilder extraFilters = request.getStartTime().isPresent() || request.getEndTime().isPresent() ? null : QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"_tier", (String[])new String[]{"data_frozen", "data_cold"}));
        DatafeedConfig.Builder previewDatafeedBuilder = TransportPreviewDatafeedAction.buildPreviewDatafeed(datafeedConfig);
        SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
            previewDatafeedBuilder.setHeaders(ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)this.clusterService.state()));
            DatafeedConfig previewDatafeedConfig = previewDatafeedBuilder.build();
            DataExtractorFactory.create((Client)new ParentTaskAssigningClient(this.client, parentTaskId), previewDatafeedConfig, extraFilters, job, this.xContentRegistry, new DatafeedTimingStatsReporter(new DatafeedTimingStats(datafeedConfig.getJobId()), (ts, refreshPolicy, listener1) -> {}), (ActionListener<DataExtractorFactory>)responseHeaderPreservingListener.delegateFailure((l, dataExtractorFactory) -> this.isDateNanos(previewDatafeedConfig, job.getDataDescription().getTimeField(), (ActionListener<Boolean>)l.delegateFailure((l2, isDateNanos) -> {
                long start = request.getStartTime().orElse(0L);
                long end = request.getEndTime().orElse(isDateNanos != false ? DateUtils.MAX_NANOSECOND_INSTANT.toEpochMilli() : Long.MAX_VALUE);
                DataExtractor dataExtractor = dataExtractorFactory.newExtractor(start, end);
                this.threadPool.executor("ml_utility").execute(() -> TransportPreviewDatafeedAction.previewDatafeed(dataExtractor, (ActionListener<PreviewDatafeedAction.Response>)l2));
            }))));
        });
    }

    static DatafeedConfig.Builder buildPreviewDatafeed(DatafeedConfig datafeed) {
        DatafeedConfig.Builder previewDatafeed = new DatafeedConfig.Builder(datafeed);
        if (!datafeed.hasAggregations()) {
            previewDatafeed.setChunkingConfig(ChunkingConfig.newAuto());
        }
        return previewDatafeed;
    }

    private void isDateNanos(DatafeedConfig datafeed, String timeField, ActionListener<Boolean> listener) {
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest();
        fieldCapabilitiesRequest.indices(datafeed.getIndices().toArray(new String[0])).indicesOptions(datafeed.getIndicesOptions());
        fieldCapabilitiesRequest.fields(new String[]{timeField});
        ClientHelper.executeWithHeadersAsync((Map)datafeed.getHeaders(), (String)"ml", (Client)this.client, (ActionType)TransportFieldCapabilitiesAction.TYPE, (ActionRequest)fieldCapabilitiesRequest, (ActionListener)listener.delegateFailureAndWrap((l, fieldCapsResponse) -> l.onResponse((Object)fieldCapsResponse.getField(timeField).containsKey("date_nanos"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void previewDatafeed(DataExtractor dataExtractor, ActionListener<PreviewDatafeedAction.Response> listener) {
        try {
            Optional<InputStream> inputStream = dataExtractor.next().data();
            StringBuilder responseBuilder = new StringBuilder("[");
            if (inputStream.isPresent()) {
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream.get(), StandardCharsets.UTF_8));){
                    responseBuilder.append(buffer.lines().collect(Collectors.joining(" ")).replace("} {", "},{"));
                }
            }
            responseBuilder.append("]");
            listener.onResponse((Object)new PreviewDatafeedAction.Response((BytesReference)new BytesArray(responseBuilder.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            dataExtractor.destroy();
        }
    }
}

