/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querylog;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.xcontent.json.JsonStringEncoder;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.session.Result;

public final class EsqlQueryLog {
    public static final String ELASTICSEARCH_QUERYLOG_PREFIX = "elasticsearch.querylog";
    public static final String ELASTICSEARCH_QUERYLOG_ERROR_MESSAGE = "elasticsearch.querylog.error.message";
    public static final String ELASTICSEARCH_QUERYLOG_ERROR_TYPE = "elasticsearch.querylog.error.type";
    public static final String ELASTICSEARCH_QUERYLOG_TOOK = "elasticsearch.querylog.took";
    public static final String ELASTICSEARCH_QUERYLOG_TOOK_MILLIS = "elasticsearch.querylog.took_millis";
    public static final String ELASTICSEARCH_QUERYLOG_PLANNING_TOOK = "elasticsearch.querylog.planning.took";
    public static final String ELASTICSEARCH_QUERYLOG_PLANNING_TOOK_MILLIS = "elasticsearch.querylog.planning.took_millis";
    public static final String ELASTICSEARCH_QUERYLOG_SUCCESS = "elasticsearch.querylog.success";
    public static final String ELASTICSEARCH_QUERYLOG_SEARCH_TYPE = "elasticsearch.querylog.search_type";
    public static final String ELASTICSEARCH_QUERYLOG_QUERY = "elasticsearch.querylog.query";
    public static final String LOGGER_NAME = "esql.querylog";
    private static final Logger queryLogger = LogManager.getLogger((String)"esql.querylog");
    private final SlowLogFields additionalFields;
    private volatile long queryWarnThreshold;
    private volatile long queryInfoThreshold;
    private volatile long queryDebugThreshold;
    private volatile long queryTraceThreshold;
    private volatile boolean includeUser;

    public EsqlQueryLog(ClusterSettings settings, SlowLogFieldProvider slowLogFieldProvider) {
        settings.initializeAndWatch(EsqlPlugin.ESQL_QUERYLOG_THRESHOLD_WARN_SETTING, this::setQueryWarnThreshold);
        settings.initializeAndWatch(EsqlPlugin.ESQL_QUERYLOG_THRESHOLD_INFO_SETTING, this::setQueryInfoThreshold);
        settings.initializeAndWatch(EsqlPlugin.ESQL_QUERYLOG_THRESHOLD_DEBUG_SETTING, this::setQueryDebugThreshold);
        settings.initializeAndWatch(EsqlPlugin.ESQL_QUERYLOG_THRESHOLD_TRACE_SETTING, this::setQueryTraceThreshold);
        settings.initializeAndWatch(EsqlPlugin.ESQL_QUERYLOG_INCLUDE_USER_SETTING, this::setIncludeUser);
        this.additionalFields = slowLogFieldProvider.create();
    }

    public void onQueryPhase(Result esqlResult, String query) {
        if (esqlResult == null) {
            return;
        }
        long tookInNanos = esqlResult.executionInfo().overallTook().nanos();
        this.log(() -> Message.of(esqlResult, query, this.includeUser ? this.additionalFields.queryFields() : Map.of()), tookInNanos);
    }

    public void onQueryFailure(String query, Exception ex, long tookInNanos) {
        this.log(() -> Message.of(query, tookInNanos, ex, this.includeUser ? this.additionalFields.queryFields() : Map.of()), tookInNanos);
    }

    private void log(Supplier<ESLogMessage> logProducer, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold) {
            queryLogger.warn((org.apache.logging.log4j.message.Message)logProducer.get());
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold) {
            queryLogger.info((org.apache.logging.log4j.message.Message)logProducer.get());
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold) {
            queryLogger.debug((org.apache.logging.log4j.message.Message)logProducer.get());
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold) {
            queryLogger.trace((org.apache.logging.log4j.message.Message)logProducer.get());
        }
    }

    public void setQueryWarnThreshold(TimeValue queryWarnThreshold) {
        this.queryWarnThreshold = queryWarnThreshold.nanos();
    }

    public void setQueryInfoThreshold(TimeValue queryInfoThreshold) {
        this.queryInfoThreshold = queryInfoThreshold.nanos();
    }

    public void setQueryDebugThreshold(TimeValue queryDebugThreshold) {
        this.queryDebugThreshold = queryDebugThreshold.nanos();
    }

    public void setQueryTraceThreshold(TimeValue queryTraceThreshold) {
        this.queryTraceThreshold = queryTraceThreshold.nanos();
    }

    public void setIncludeUser(boolean includeUser) {
        this.includeUser = includeUser;
    }

    static final class Message {
        Message() {
        }

        private static String escapeJson(String text) {
            byte[] sourceEscaped = JsonStringEncoder.getInstance().quoteAsUTF8(text);
            return new String(sourceEscaped, StandardCharsets.UTF_8);
        }

        public static ESLogMessage of(Result esqlResult, String query, Map<String, String> additionalFields) {
            HashMap<String, Object> jsonFields = new HashMap<String, Object>();
            jsonFields.putAll(additionalFields);
            Message.addGenericFields(jsonFields, query, true);
            Message.addResultFields(jsonFields, esqlResult);
            return new ESLogMessage().withFields(jsonFields);
        }

        public static ESLogMessage of(String query, long took, Exception exception, Map<String, String> additionalFields) {
            HashMap<String, Object> jsonFields = new HashMap<String, Object>();
            jsonFields.putAll(additionalFields);
            Message.addGenericFields(jsonFields, query, false);
            Message.addErrorFields(jsonFields, took, exception);
            return new ESLogMessage().withFields(jsonFields);
        }

        private static void addGenericFields(Map<String, Object> fieldMap, String query, boolean success) {
            String source = Message.escapeJson(query);
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_SUCCESS, success);
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_SEARCH_TYPE, "ESQL");
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_QUERY, source);
        }

        private static void addResultFields(Map<String, Object> fieldMap, Result esqlResult) {
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_TOOK, esqlResult.executionInfo().overallTook().nanos());
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_TOOK_MILLIS, esqlResult.executionInfo().overallTook().millis());
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_PLANNING_TOOK, esqlResult.executionInfo().planningTookTime().nanos());
            fieldMap.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_PLANNING_TOOK_MILLIS, esqlResult.executionInfo().planningTookTime().millis());
        }

        private static void addErrorFields(Map<String, Object> jsonFields, long took, Exception exception) {
            jsonFields.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_TOOK, took);
            jsonFields.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_TOOK_MILLIS, took / 1000000L);
            jsonFields.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_ERROR_MESSAGE, exception.getMessage() == null ? "" : exception.getMessage());
            jsonFields.put(EsqlQueryLog.ELASTICSEARCH_QUERYLOG_ERROR_TYPE, exception.getClass().getName());
        }
    }
}

