/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsQueryExec
extends LeafExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "EsQueryExec", EsQueryExec::readFrom);
    public static final EsField DOC_ID_FIELD = new EsField("_doc", DataType.DOC_DATA_TYPE, Map.of(), false);
    public static final List<Sort> NO_SORTS = List.of();
    private final String indexPattern;
    private final IndexMode indexMode;
    private final Map<String, IndexMode> indexNameWithModes;
    private final List<Attribute> attrs;
    private final QueryBuilder query;
    private final Expression limit;
    private final List<Sort> sorts;
    private final Integer estimatedRowSize;

    public EsQueryExec(Source source, String indexPattern, IndexMode indexMode, Map<String, IndexMode> indexNameWithModes, List<Attribute> attributes, QueryBuilder query) {
        this(source, indexPattern, indexMode, indexNameWithModes, attributes, query, null, null, null);
    }

    public EsQueryExec(Source source, String indexPattern, IndexMode indexMode, Map<String, IndexMode> indexNameWithModes, List<Attribute> attrs, QueryBuilder query, Expression limit, List<Sort> sorts, Integer estimatedRowSize) {
        super(source);
        this.indexPattern = indexPattern;
        this.indexMode = indexMode;
        this.indexNameWithModes = indexNameWithModes;
        this.attrs = attrs;
        this.query = query;
        this.limit = limit;
        this.sorts = sorts;
        this.estimatedRowSize = estimatedRowSize;
    }

    private static EsQueryExec readFrom(StreamInput in) throws IOException {
        Map<String, IndexMode> indexNameWithModes;
        String indexPattern;
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            indexPattern = in.readString();
            indexNameWithModes = in.readMap(IndexMode::readFrom);
        } else {
            EsIndex index = EsIndex.readFrom(in);
            indexPattern = index.name();
            indexNameWithModes = index.indexNameWithModes();
        }
        IndexMode indexMode = EsRelation.readIndexMode(in);
        List attrs = in.readNamedWriteableCollectionAsList(Attribute.class);
        QueryBuilder query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        Expression limit = (Expression)in.readOptionalNamedWriteable(Expression.class);
        in.readOptionalCollectionAsList(EsQueryExec::readSort);
        Integer rowSize = in.readOptionalVInt();
        return new EsQueryExec(source, indexPattern, indexMode, indexNameWithModes, attrs, query, limit, NO_SORTS, rowSize);
    }

    private static Sort readSort(StreamInput in) throws IOException {
        return FieldSort.readFrom(in);
    }

    private static void writeSort(StreamOutput out, Sort sort) {
        throw new IllegalStateException("sorts are no longer serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeString(this.indexPattern);
            out.writeMap(this.indexNameWithModes, (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        } else {
            new EsIndex(this.indexPattern, Map.of(), this.indexNameWithModes).writeTo(out);
        }
        EsRelation.writeIndexMode(out, this.indexMode());
        out.writeNamedWriteableCollection(this.output());
        out.writeOptionalNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.limit());
        out.writeOptionalCollection(NO_SORTS, EsQueryExec::writeSort);
        out.writeOptionalVInt(this.estimatedRowSize());
    }

    public String getWriteableName() {
        return EsQueryExec.ENTRY.name;
    }

    public static boolean isSourceAttribute(Attribute attr) {
        return DOC_ID_FIELD.getName().equals(attr.name());
    }

    public boolean hasScoring() {
        for (Attribute a : this.attrs()) {
            if (!(a instanceof MetadataAttribute) || !a.name().equals("_score")) continue;
            return true;
        }
        return false;
    }

    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create((Node)this, EsQueryExec::new, (Object)this.indexPattern, (Object)this.indexMode, this.indexNameWithModes, this.attrs, (Object)this.query, (Object)this.limit, this.sorts, (Object)this.estimatedRowSize);
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public Map<String, IndexMode> indexNameWithModes() {
        return this.indexNameWithModes;
    }

    public QueryBuilder query() {
        return this.query;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Sort> sorts() {
        return this.sorts;
    }

    public List<Attribute> attrs() {
        return this.attrs;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size;
        if (this.sorts == null || this.sorts.isEmpty()) {
            state.add(false, 4);
            size = state.consumeAllFields(false);
        } else {
            state.add(false, 8);
            size = state.consumeAllFields(true);
        }
        return Objects.equals(this.estimatedRowSize, size) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs, this.query, this.limit, this.sorts, size);
    }

    public EsQueryExec withLimit(Expression limit) {
        return Objects.equals(this.limit, limit) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs, this.query, limit, this.sorts, this.estimatedRowSize);
    }

    public boolean canPushSorts() {
        return this.indexMode != IndexMode.TIME_SERIES;
    }

    public EsQueryExec withSorts(List<Sort> sorts) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            assert (false) : "time-series index mode doesn't support sorts";
            throw new UnsupportedOperationException("time-series index mode doesn't support sorts");
        }
        return Objects.equals(this.sorts, sorts) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs, this.query, this.limit, sorts, this.estimatedRowSize);
    }

    public EsQueryExec withQuery(QueryBuilder query) {
        return Objects.equals(this.query, query) ? this : new EsQueryExec(this.source(), this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs, query, this.limit, this.sorts, this.estimatedRowSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.indexMode, this.indexNameWithModes, this.attrs, this.query, this.limit, this.sorts);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.indexNameWithModes, other.indexNameWithModes) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "], indexMode[" + String.valueOf(this.indexMode) + "], query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "]" + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], sort[" + (this.sorts != null ? this.sorts.toString() : "") + "] estimatedRowSize[" + this.estimatedRowSize + "]";
    }

    public record FieldSort(FieldAttribute field, Order.OrderDirection direction, Order.NullsPosition nulls) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            FieldSortBuilder builder = new FieldSortBuilder(this.field.name());
            builder.order(Direction.from(this.direction).asOrder());
            builder.missing((Object)Missing.from(this.nulls).searchOrder());
            builder.unmappedType(this.field.dataType().esType());
            return builder;
        }

        private static FieldSort readFrom(StreamInput in) throws IOException {
            return new FieldSort(FieldAttribute.readFrom((StreamInput)in), (Order.OrderDirection)in.readEnum(Order.OrderDirection.class), (Order.NullsPosition)in.readEnum(Order.NullsPosition.class));
        }

        @Override
        public DataType resulType() {
            return this.field.dataType();
        }
    }

    public static enum Missing {
        FIRST("_first"),
        LAST("_last"),
        ANY(null);

        private final String searchOrder;

        private Missing(String searchOrder) {
            this.searchOrder = searchOrder;
        }

        public static Missing from(Order.NullsPosition pos) {
            return switch (pos) {
                case Order.NullsPosition.FIRST -> FIRST;
                case Order.NullsPosition.LAST -> LAST;
                default -> ANY;
            };
        }

        public String searchOrder() {
            return this.searchOrder;
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction from(Order.OrderDirection dir) {
            return dir == null || dir == Order.OrderDirection.ASC ? ASC : DESC;
        }

        public SortOrder asOrder() {
            return this == ASC ? SortOrder.ASC : SortOrder.DESC;
        }
    }

    public record ScoreSort(Order.OrderDirection direction) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            return new ScoreSortBuilder();
        }

        @Override
        public FieldAttribute field() {
            return null;
        }

        @Override
        public DataType resulType() {
            return DataType.DOUBLE;
        }
    }

    public record GeoDistanceSort(FieldAttribute field, Order.OrderDirection direction, double lat, double lon) implements Sort
    {
        @Override
        public SortBuilder<?> sortBuilder() {
            GeoDistanceSortBuilder builder = new GeoDistanceSortBuilder(this.field.name(), this.lat, this.lon);
            builder.order(Direction.from(this.direction).asOrder());
            return builder;
        }

        @Override
        public DataType resulType() {
            return DataType.DOUBLE;
        }
    }

    public static interface Sort {
        public SortBuilder<?> sortBuilder();

        public Order.OrderDirection direction();

        public FieldAttribute field();

        public DataType resulType();
    }
}

