/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.util.ReflectionUtils;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class OptimizerRules {

    public static interface CoordinatorOnly
    extends LocalAware<LogicalPlan> {
        @Override
        default public Rule<LogicalPlan, LogicalPlan> local() {
            return null;
        }
    }

    public static interface LocalAware<SubPlan extends LogicalPlan> {
        public Rule<SubPlan, LogicalPlan> local();
    }

    public static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        private final TransformDirection direction;

        protected ParameterizedOptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformDown(this.typeToken(), t -> this.rule(t, context)) : (LogicalPlan)plan.transformUp(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }

    public static enum TransformDirection {
        UP,
        DOWN;

    }

    public static abstract class OptimizerExpressionRule<E extends Expression>
    extends ParameterizedRule<LogicalPlan, LogicalPlan, LogicalOptimizerContext> {
        private final TransformDirection direction;
        private final Class<E> expressionTypeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        public OptimizerExpressionRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan, LogicalOptimizerContext ctx) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)((Object)plan.transformExpressionsDown(this::shouldVisit, this.expressionTypeToken, e -> this.rule(e, ctx))) : (LogicalPlan)((Object)plan.transformExpressionsUp(this::shouldVisit, this.expressionTypeToken, e -> this.rule(e, ctx)));
        }

        protected abstract Expression rule(E var1, LogicalOptimizerContext var2);

        protected boolean shouldVisit(Node<?> node) {
            return !(node instanceof EsRelation || node instanceof Project || node instanceof Limit);
        }

        public Class<E> expressionToken() {
            return this.expressionTypeToken;
        }
    }

    public static abstract class OptimizerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        private final TransformDirection direction;

        public OptimizerRule() {
            this(TransformDirection.DOWN);
        }

        protected OptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformDown(this.typeToken(), this::rule) : (LogicalPlan)plan.transformUp(this.typeToken(), this::rule);
        }

        protected abstract LogicalPlan rule(SubPlan var1);
    }
}

