/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringNoLengthEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Substring
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Substring", Substring::new);
    private final Expression str;
    private final Expression start;
    private final Expression length;

    @FunctionInfo(returnType={"keyword"}, description="Returns a substring of a string, specified by a start position and an optional length.", examples={@Example(file="docs", tag="substring", description="This example returns the first three characters of every last name:"), @Example(file="docs", tag="substringEnd", description="A negative start position is interpreted as being relative to the end of the string.\nThis example returns the last three characters of of every last name:"), @Example(file="docs", tag="substringRemainder", description="If length is omitted, substring returns the remainder of the string.\nThis example returns all characters except for the first:")})
    public Substring(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.") Expression str, @Param(name="start", type={"integer"}, description="Start position.") Expression start, @Param(optional=true, name="length", type={"integer"}, description="Length of the substring from the start position. Optional; if omitted, all positions after `start` are returned.") Expression length) {
        super(source, length == null ? Arrays.asList(str, start) : Arrays.asList(str, start, length));
        this.str = str;
        this.start = start;
        this.length = length;
    }

    private Substring(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeOptionalNamedWriteable((NamedWriteable)this.length);
    }

    public String getWriteableName() {
        return Substring.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType((Expression)this.start, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.length == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isType((Expression)this.length, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{"integer"});
    }

    public boolean foldable() {
        return this.str.foldable() && this.start.foldable() && (this.length == null || this.length.foldable());
    }

    static BytesRef process(BytesRef str, int start) {
        int length = str.length;
        return Substring.process(str, start, length);
    }

    static BytesRef process(BytesRef str, int start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length parameter cannot be negative, found [" + length + "]");
        }
        if (str.length == 0) {
            return str;
        }
        int codePointCount = UnicodeUtil.codePointCount((BytesRef)str);
        int indexStart = Substring.indexStart(codePointCount, start);
        int indexEnd = Math.min(codePointCount, indexStart + length);
        String s = str.utf8ToString();
        return new BytesRef((CharSequence)s.substring(s.offsetByCodePoints(0, indexStart), s.offsetByCodePoints(0, indexEnd)));
    }

    private static int indexStart(int codePointCount, int start) {
        int indexStart = start > 0 ? start - 1 : (start < 0 ? codePointCount + start : start);
        return Math.min(Math.max(0, indexStart), codePointCount);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Substring(this.source(), newChildren.get(0), newChildren.get(1), this.length == null ? null : newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Substring::new, (Object)this.str, (Object)this.start, (Object)this.length);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strFactory = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory startFactory = toEvaluator.apply(this.start);
        if (this.length == null) {
            return new SubstringNoLengthEvaluator.Factory(this.source(), strFactory, startFactory);
        }
        EvalOperator.ExpressionEvaluator.Factory lengthFactory = toEvaluator.apply(this.length);
        return new SubstringEvaluator.Factory(this.source(), strFactory, startFactory, lengthFactory);
    }

    Expression str() {
        return this.str;
    }

    Expression start() {
        return this.start;
    }

    Expression length() {
        return this.length;
    }
}

